/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0002'(B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0012J\b\u0010!\u001a\u0004\u0018\u00010\fJ\b\u0010\"\u001a\u0004\u0018\u00010\tJ\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0007H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lcom/facebook/GraphResponse;", "", "request", "Lcom/facebook/GraphRequest;", "connection", "Ljava/net/HttpURLConnection;", "rawResponse", "", "graphObject", "Lorg/json/JSONObject;", "(Lcom/facebook/GraphRequest;Ljava/net/HttpURLConnection;Ljava/lang/String;Lorg/json/JSONObject;)V", "graphObjects", "Lorg/json/JSONArray;", "(Lcom/facebook/GraphRequest;Ljava/net/HttpURLConnection;Ljava/lang/String;Lorg/json/JSONArray;)V", "error", "Lcom/facebook/FacebookRequestError;", "(Lcom/facebook/GraphRequest;Ljava/net/HttpURLConnection;Lcom/facebook/FacebookRequestError;)V", "graphObjectArray", "(Lcom/facebook/GraphRequest;Ljava/net/HttpURLConnection;Ljava/lang/String;Lorg/json/JSONObject;Lorg/json/JSONArray;Lcom/facebook/FacebookRequestError;)V", "getConnection", "()Ljava/net/HttpURLConnection;", "getError", "()Lcom/facebook/FacebookRequestError;", "jsonArray", "getJsonArray", "()Lorg/json/JSONArray;", "jsonObject", "getJsonObject", "()Lorg/json/JSONObject;", "getRawResponse", "()Ljava/lang/String;", "getRequest", "()Lcom/facebook/GraphRequest;", "getJSONArray", "getJSONObject", "getRequestForPagedResults", "direction", "Lcom/facebook/GraphResponse$PagingDirection;", "toString", "Companion", "PagingDirection", "facebook-core_release"})
public final class GraphResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraphRequest request;
    @Nullable
    private final HttpURLConnection connection;
    @Nullable
    private final String rawResponse;
    @Nullable
    private final JSONObject graphObject;
    @Nullable
    private final JSONArray graphObjectArray;
    @Nullable
    private final FacebookRequestError error;
    @Nullable
    private final JSONObject jsonObject;
    @Nullable
    private final JSONArray jsonArray;
    @Nullable
    private static final String TAG = GraphResponse.class.getCanonicalName();
    @NotNull
    public static final String NON_JSON_RESPONSE_PROPERTY = "FACEBOOK_NON_JSON_RESULT";
    @NotNull
    public static final String SUCCESS_KEY = "success";
    @NotNull
    private static final String CODE_KEY = "code";
    @NotNull
    private static final String BODY_KEY = "body";
    @NotNull
    private static final String RESPONSE_LOG_TAG = "Response";

    public GraphResponse(@NotNull GraphRequest request, @Nullable HttpURLConnection connection, @Nullable String rawResponse, @Nullable JSONObject graphObject, @Nullable JSONArray graphObjectArray, @Nullable FacebookRequestError error) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.connection = connection;
        this.rawResponse = rawResponse;
        this.graphObject = graphObject;
        this.graphObjectArray = graphObjectArray;
        this.error = error;
        this.jsonObject = this.graphObject;
        this.jsonArray = this.graphObjectArray;
    }

    @NotNull
    public final GraphRequest getRequest() {
        return this.request;
    }

    @Nullable
    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public final String getRawResponse() {
        return this.rawResponse;
    }

    @Nullable
    public final FacebookRequestError getError() {
        return this.error;
    }

    public GraphResponse(@NotNull GraphRequest request, @Nullable HttpURLConnection connection, @NotNull String rawResponse, @Nullable JSONObject graphObject) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)rawResponse, (String)"rawResponse");
        this(request, connection, rawResponse, graphObject, null, null);
    }

    public GraphResponse(@NotNull GraphRequest request, @Nullable HttpURLConnection connection, @NotNull String rawResponse, @NotNull JSONArray graphObjects) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)rawResponse, (String)"rawResponse");
        Intrinsics.checkNotNullParameter((Object)graphObjects, (String)"graphObjects");
        this(request, connection, rawResponse, null, graphObjects, null);
    }

    public GraphResponse(@NotNull GraphRequest request, @Nullable HttpURLConnection connection, @NotNull FacebookRequestError error) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this(request, connection, null, null, null, error);
    }

    @Nullable
    public final JSONObject getJSONObject() {
        return this.graphObject;
    }

    @Nullable
    public final JSONObject getJsonObject() {
        return this.jsonObject;
    }

    @Nullable
    public final JSONArray getJSONArray() {
        return this.graphObjectArray;
    }

    @Nullable
    public final JSONArray getJsonArray() {
        return this.jsonArray;
    }

    @Nullable
    public final GraphRequest getRequestForPagedResults(@NotNull PagingDirection direction) {
        GraphRequest graphRequest;
        JSONObject pagingInfo;
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        String link = null;
        if (this.graphObject != null && (pagingInfo = this.graphObject.optJSONObject("paging")) != null) {
            String string = link = direction == PagingDirection.NEXT ? pagingInfo.optString("next") : pagingInfo.optString("previous");
        }
        if (Utility.isNullOrEmpty(link)) {
            return null;
        }
        if (link != null && Intrinsics.areEqual(link, (Object)this.request.getUrlForSingleRequest())) {
            return null;
        }
        GraphRequest pagingRequest = null;
        try {
            graphRequest = new GraphRequest(this.request.getAccessToken(), new URL(link));
        }
        catch (MalformedURLException e) {
            return null;
        }
        pagingRequest = graphRequest;
        return pagingRequest;
    }

    @NotNull
    public String toString() {
        String string;
        try {
            Locale locale = Locale.US;
            String string2 = "%d";
            Object[] objectArray = new Object[1];
            HttpURLConnection httpURLConnection = this.connection;
            objectArray[0] = httpURLConnection != null ? httpURLConnection.getResponseCode() : 200;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
            string = string3;
        }
        catch (IOException e) {
            string = "unknown";
        }
        String responseCode = string;
        String string4 = "{Response: " + " responseCode: " + responseCode + ", graphObject: " + this.graphObject + ", error: " + this.error + "}";
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder()\n        \u2026(\"}\")\n        .toString()");
        return string4;
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> fromHttpConnection$facebook_core_release(@NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
        return Companion.fromHttpConnection$facebook_core_release(connection, requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> createResponsesFromStream$facebook_core_release(@Nullable InputStream stream, @Nullable HttpURLConnection connection, @NotNull GraphRequestBatch requests) throws FacebookException, JSONException, IOException {
        return Companion.createResponsesFromStream$facebook_core_release(stream, connection, requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> createResponsesFromString$facebook_core_release(@NotNull String responseString, @Nullable HttpURLConnection connection, @NotNull GraphRequestBatch requests) throws FacebookException, JSONException, IOException {
        return Companion.createResponsesFromString$facebook_core_release(responseString, connection, requests);
    }

    @JvmStatic
    @NotNull
    public static final List<GraphResponse> constructErrorResponses(@NotNull List<GraphRequest> requests, @Nullable HttpURLConnection connection, @Nullable FacebookException error) {
        return Companion.constructErrorResponses(requests, connection, error);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J*\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J/\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001fJ#\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/facebook/GraphResponse$Companion;", "", "()V", "BODY_KEY", "", "CODE_KEY", "NON_JSON_RESPONSE_PROPERTY", "RESPONSE_LOG_TAG", "SUCCESS_KEY", "TAG", "constructErrorResponses", "", "Lcom/facebook/GraphResponse;", "requests", "Lcom/facebook/GraphRequest;", "connection", "Ljava/net/HttpURLConnection;", "error", "Lcom/facebook/FacebookException;", "createResponseFromObject", "request", "sourceObject", "originalResult", "createResponsesFromObject", "createResponsesFromStream", "stream", "Ljava/io/InputStream;", "Lcom/facebook/GraphRequestBatch;", "createResponsesFromStream$facebook_core_release", "createResponsesFromString", "responseString", "createResponsesFromString$facebook_core_release", "fromHttpConnection", "fromHttpConnection$facebook_core_release", "facebook-core_release"})
    @SourceDebugExtension(value={"SMAP\nGraphResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphResponse.kt\ncom/facebook/GraphResponse$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1549#2:360\n1620#2,3:361\n*S KotlinDebug\n*F\n+ 1 GraphResponse.kt\ncom/facebook/GraphResponse$Companion\n*L\n355#1:360\n355#1:361,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final List<GraphResponse> fromHttpConnection$facebook_core_release(@NotNull HttpURLConnection connection, @NotNull GraphRequestBatch requests) {
            List<GraphResponse> list;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            InputStream stream = null;
            try {
                if (!FacebookSdk.isFullyInitialized()) {
                    String msg = "GraphRequest can't be used when Facebook SDK isn't fully initialized";
                    Log.e((String)TAG, (String)msg);
                    throw new FacebookException(msg);
                }
                stream = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
                list = this.createResponsesFromStream$facebook_core_release(stream, connection, requests);
            }
            catch (FacebookException facebookException) {
                Object[] objectArray = new Object[]{facebookException};
                Logger.Companion.log(LoggingBehavior.REQUESTS, GraphResponse.RESPONSE_LOG_TAG, "Response <Error>: %s", objectArray);
                list = this.constructErrorResponses(requests, connection, facebookException);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{exception};
                Logger.Companion.log(LoggingBehavior.REQUESTS, GraphResponse.RESPONSE_LOG_TAG, "Response <Error>: %s", objectArray);
                list = this.constructErrorResponses(requests, connection, new FacebookException(exception));
            }
            finally {
                Utility.closeQuietly(stream);
            }
            return list;
        }

        @JvmStatic
        @NotNull
        public final List<GraphResponse> createResponsesFromStream$facebook_core_release(@Nullable InputStream stream, @Nullable HttpURLConnection connection, @NotNull GraphRequestBatch requests) throws FacebookException, JSONException, IOException {
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            String responseString = Utility.readStreamToString(stream);
            Object[] objectArray = new Object[]{responseString.length(), responseString};
            Logger.Companion.log(LoggingBehavior.INCLUDE_RAW_RESPONSES, GraphResponse.RESPONSE_LOG_TAG, "Response (raw)\n  Size: %d\n  Response:\n%s\n", objectArray);
            return this.createResponsesFromString$facebook_core_release(responseString, connection, requests);
        }

        @JvmStatic
        @NotNull
        public final List<GraphResponse> createResponsesFromString$facebook_core_release(@NotNull String responseString, @Nullable HttpURLConnection connection, @NotNull GraphRequestBatch requests) throws FacebookException, JSONException, IOException {
            Intrinsics.checkNotNullParameter((Object)responseString, (String)"responseString");
            Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
            JSONTokener tokener = new JSONTokener(responseString);
            Object resultObject = tokener.nextValue();
            List list = requests;
            Intrinsics.checkNotNullExpressionValue((Object)resultObject, (String)"resultObject");
            List<GraphResponse> responses = this.createResponsesFromObject(connection, list, resultObject);
            Object[] objectArray = new Object[]{requests.getId(), responseString.length(), responses};
            Logger.Companion.log(LoggingBehavior.REQUESTS, GraphResponse.RESPONSE_LOG_TAG, "Response\n  Id: %s\n  Size: %d\n  Responses:\n%s\n", objectArray);
            return responses;
        }

        private final List<GraphResponse> createResponsesFromObject(HttpURLConnection connection, List<GraphRequest> requests, Object sourceObject) throws FacebookException, JSONException {
            Object obj = sourceObject;
            int numRequests = requests.size();
            List responses = new ArrayList(numRequests);
            Object originalResult = obj;
            if (numRequests == 1) {
                GraphRequest request = requests.get(0);
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put(GraphResponse.BODY_KEY, obj);
                    HttpURLConnection httpURLConnection = connection;
                    int responseCode = httpURLConnection != null ? httpURLConnection.getResponseCode() : 200;
                    jsonObject.put(GraphResponse.CODE_KEY, responseCode);
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.put((Object)jsonObject);
                    obj = jsonArray;
                }
                catch (JSONException e) {
                    responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, (Exception)((Object)e))));
                }
                catch (IOException e) {
                    responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, e)));
                }
            }
            if (!(obj instanceof JSONArray) || ((JSONArray)obj).length() != numRequests) {
                throw new FacebookException("Unexpected number of results");
            }
            Object jsonArray = obj;
            int n = ((JSONArray)jsonArray).length();
            for (int i = 0; i < n; ++i) {
                GraphRequest request = requests.get(i);
                try {
                    Object obj2 = ((JSONArray)jsonArray).get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)obj2, (String)"obj");
                    responses.add(this.createResponseFromObject(request, connection, obj2, originalResult));
                    continue;
                }
                catch (JSONException e) {
                    responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, (Exception)((Object)e))));
                    continue;
                }
                catch (FacebookException e) {
                    responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, e)));
                }
            }
            return responses;
        }

        private final GraphResponse createResponseFromObject(GraphRequest request, HttpURLConnection connection, Object sourceObject, Object originalResult) throws JSONException {
            Object obj = sourceObject;
            if (obj instanceof JSONObject) {
                Object jsonObject = obj;
                FacebookRequestError error = FacebookRequestError.Companion.checkResponseAndCreateError((JSONObject)jsonObject, originalResult, connection);
                if (error != null) {
                    Log.e((String)TAG, (String)error.toString());
                    if (error.getErrorCode() == 190 && Utility.isCurrentAccessToken(request.getAccessToken())) {
                        if (error.getSubErrorCode() != 493) {
                            AccessToken.Companion.setCurrentAccessToken(null);
                        } else {
                            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
                            boolean bl = accessToken != null ? !accessToken.isExpired() : false;
                            if (bl) {
                                AccessToken.Companion.expireCurrentAccessToken();
                            }
                        }
                    }
                    return new GraphResponse(request, connection, error);
                }
                Object body = Utility.getStringPropertyAsJSON((JSONObject)jsonObject, GraphResponse.BODY_KEY, GraphResponse.NON_JSON_RESPONSE_PROPERTY);
                if (body instanceof JSONObject) {
                    return new GraphResponse(request, connection, ((JSONObject)body).toString(), (JSONObject)body);
                }
                if (body instanceof JSONArray) {
                    return new GraphResponse(request, connection, ((JSONArray)body).toString(), (JSONArray)body);
                }
                Object object = JSONObject.NULL;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NULL");
                obj = object;
            }
            if (obj != JSONObject.NULL) {
                throw new FacebookException("Got unexpected object type in response, class: " + obj.getClass().getSimpleName());
            }
            return new GraphResponse(request, connection, obj.toString(), null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<GraphResponse> constructErrorResponses(@NotNull List<GraphRequest> requests, @Nullable HttpURLConnection connection, @Nullable FacebookException error) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            Iterable $this$map$iv = requests;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GraphRequest graphRequest = (GraphRequest)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GraphResponse((GraphRequest)it, connection, new FacebookRequestError(connection, error)));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/GraphResponse$PagingDirection;", "", "(Ljava/lang/String;I)V", "NEXT", "PREVIOUS", "facebook-core_release"})
    public static final class PagingDirection
    extends Enum<PagingDirection> {
        public static final /* enum */ PagingDirection NEXT = new PagingDirection();
        public static final /* enum */ PagingDirection PREVIOUS = new PagingDirection();
        private static final /* synthetic */ PagingDirection[] $VALUES;

        public static PagingDirection[] values() {
            return (PagingDirection[])$VALUES.clone();
        }

        public static PagingDirection valueOf(String value) {
            return Enum.valueOf(PagingDirection.class, value);
        }

        static {
            $VALUES = pagingDirectionArray = new PagingDirection[]{PagingDirection.NEXT, PagingDirection.PREVIOUS};
        }
    }
}

