/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.PersistedEvents;
import com.facebook.appevents.SessionEventsState;
import com.facebook.internal.AttributionIdentifiers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\tH\u0086\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/appevents/AppEventCollection;", "", "()V", "eventCount", "", "getEventCount", "()I", "stateMap", "Ljava/util/HashMap;", "Lcom/facebook/appevents/AccessTokenAppIdPair;", "Lcom/facebook/appevents/SessionEventsState;", "addEvent", "", "accessTokenAppIdPair", "appEvent", "Lcom/facebook/appevents/AppEvent;", "addPersistedEvents", "persistedEvents", "Lcom/facebook/appevents/PersistedEvents;", "get", "getSessionEventsState", "accessTokenAppId", "keySet", "", "facebook-core_release"})
public final class AppEventCollection {
    @NotNull
    private final HashMap<AccessTokenAppIdPair, SessionEventsState> stateMap = new HashMap();

    public final synchronized void addPersistedEvents(@Nullable PersistedEvents persistedEvents) {
        if (persistedEvents == null) {
            return;
        }
        for (Map.Entry<AccessTokenAppIdPair, List<AppEvent>> entry : persistedEvents.entrySet()) {
            SessionEventsState state = this.getSessionEventsState(entry.getKey());
            if (state == null) continue;
            for (AppEvent appEvent : entry.getValue()) {
                state.addEvent(appEvent);
            }
        }
    }

    public final synchronized void addEvent(@NotNull AccessTokenAppIdPair accessTokenAppIdPair, @NotNull AppEvent appEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)accessTokenAppIdPair, (String)"accessTokenAppIdPair");
            Intrinsics.checkNotNullParameter((Object)appEvent, (String)"appEvent");
            SessionEventsState sessionEventsState = this.getSessionEventsState(accessTokenAppIdPair);
            if (sessionEventsState == null) break block0;
            sessionEventsState.addEvent(appEvent);
        }
    }

    @NotNull
    public final synchronized Set<AccessTokenAppIdPair> keySet() {
        Set<AccessTokenAppIdPair> set = this.stateMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"stateMap.keys");
        return set;
    }

    @Nullable
    public final synchronized SessionEventsState get(@NotNull AccessTokenAppIdPair accessTokenAppIdPair) {
        Intrinsics.checkNotNullParameter((Object)accessTokenAppIdPair, (String)"accessTokenAppIdPair");
        return this.stateMap.get(accessTokenAppIdPair);
    }

    public final synchronized int getEventCount() {
        int count = 0;
        for (SessionEventsState sessionEventsState : this.stateMap.values()) {
            count += sessionEventsState.getAccumulatedEventCount();
        }
        return count;
    }

    private final synchronized SessionEventsState getSessionEventsState(AccessTokenAppIdPair accessTokenAppId) {
        Context context;
        AttributionIdentifiers identifier;
        SessionEventsState eventsState = this.stateMap.get(accessTokenAppId);
        if (eventsState == null && (identifier = AttributionIdentifiers.Companion.getAttributionIdentifiers(context = FacebookSdk.getApplicationContext())) != null) {
            eventsState = new SessionEventsState(identifier, AppEventsLogger.Companion.getAnonymousAppDeviceGUID(context));
        }
        if (eventsState == null) {
            return null;
        }
        ((Map)this.stateMap).put(accessTokenAppId, eventsState);
        return eventsState;
    }
}

