/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.cloudbridge;

import com.facebook.GraphRequest;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.cloudbridge.AppEventsConversionsAPITransformer;
import com.facebook.appevents.cloudbridge.AppEventsConversionsAPITransformerWebRequests;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001@B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010 \u001a\u00020!2\u001a\u0010\"\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001b\u0018\u00010#H\u0000\u00a2\u0006\u0002\b$J \u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0007J\n\u0010)\u001a\u0004\u0018\u00010\fH\u0007J=\u0010*\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010\u00052\u0018\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001b0#2\b\b\u0002\u0010-\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b.\u0010/J\u0085\u0001\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\f2\b\u00103\u001a\u0004\u0018\u00010\f2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u001b2\b\b\u0002\u00105\u001a\u00020\u00052<\u00106\u001a8\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0015\u0012\u0013\u0018\u00010\u0005\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020!\u0018\u000107H\u0000\u00a2\u0006\u0002\b;J$\u0010<\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001b\u0018\u00010#2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R,\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001b0\u001aX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006A"}, d2={"Lcom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests;", "", "()V", "ACCEPTABLE_HTTP_RESPONSE", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "MAX_CACHED_TRANSFORMED_EVENTS", "MAX_PROCESSED_TRANSFORMED_EVENTS", "MAX_RETRY_COUNT", "RETRY_EVENTS_HTTP_RESPONSE", "TAG", "", "TIMEOUT_INTERVAL", "credentials", "Lcom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests$CloudBridgeCredentials;", "getCredentials$facebook_core_release", "()Lcom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests$CloudBridgeCredentials;", "setCredentials$facebook_core_release", "(Lcom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests$CloudBridgeCredentials;)V", "currentRetryCount", "getCurrentRetryCount$facebook_core_release", "()I", "setCurrentRetryCount$facebook_core_release", "(I)V", "transformedEvents", "", "", "getTransformedEvents$facebook_core_release", "()Ljava/util/List;", "setTransformedEvents$facebook_core_release", "(Ljava/util/List;)V", "appendEvents", "", "events", "", "appendEvents$facebook_core_release", "configure", "datasetID", "url", "accessKey", "getCredentials", "handleError", "responseCode", "processedEvents", "maxRetryCount", "handleError$facebook_core_release", "(Ljava/lang/Integer;Ljava/util/List;I)V", "makeHttpRequest", "urlStr", "requestMethod", "jsonBodyStr", "requestProperties", "timeOutInterval", "requestCallback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "requestResult", "makeHttpRequest$facebook_core_release", "transformAppEventRequestForCAPIG", "request", "Lcom/facebook/GraphRequest;", "transformGraphRequestAndSendToCAPIGEndPoint", "CloudBridgeCredentials", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nAppEventsConversionsAPITransformerWebRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppEventsConversionsAPITransformerWebRequests.kt\ncom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1855#2,2:292\n1#3:294\n*S KotlinDebug\n*F\n+ 1 AppEventsConversionsAPITransformerWebRequests.kt\ncom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests\n*L\n239#1:292,2\n*E\n"})
public final class AppEventsConversionsAPITransformerWebRequests {
    @NotNull
    public static final AppEventsConversionsAPITransformerWebRequests INSTANCE = new AppEventsConversionsAPITransformerWebRequests();
    @NotNull
    private static final String TAG = "CAPITransformerWebRequests";
    public static final int MAX_CACHED_TRANSFORMED_EVENTS = 1000;
    private static final int MAX_PROCESSED_TRANSFORMED_EVENTS = 10;
    private static final int TIMEOUT_INTERVAL = 60000;
    @NotNull
    private static final HashSet<Integer> ACCEPTABLE_HTTP_RESPONSE;
    @NotNull
    private static final HashSet<Integer> RETRY_EVENTS_HTTP_RESPONSE;
    public static CloudBridgeCredentials credentials;
    public static List<Map<String, Object>> transformedEvents;
    public static final int MAX_RETRY_COUNT = 5;
    private static int currentRetryCount;

    private AppEventsConversionsAPITransformerWebRequests() {
    }

    @NotNull
    public final CloudBridgeCredentials getCredentials$facebook_core_release() {
        CloudBridgeCredentials cloudBridgeCredentials = credentials;
        if (cloudBridgeCredentials != null) {
            return cloudBridgeCredentials;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"credentials");
        return null;
    }

    public final void setCredentials$facebook_core_release(@NotNull CloudBridgeCredentials cloudBridgeCredentials) {
        Intrinsics.checkNotNullParameter((Object)cloudBridgeCredentials, (String)"<set-?>");
        credentials = cloudBridgeCredentials;
    }

    @NotNull
    public final List<Map<String, Object>> getTransformedEvents$facebook_core_release() {
        List<Map<String, Object>> list = transformedEvents;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"transformedEvents");
        return null;
    }

    public final void setTransformedEvents$facebook_core_release(@NotNull List<Map<String, Object>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        transformedEvents = list;
    }

    public final int getCurrentRetryCount$facebook_core_release() {
        return currentRetryCount;
    }

    public final void setCurrentRetryCount$facebook_core_release(int n) {
        currentRetryCount = n;
    }

    @JvmStatic
    public static final void configure(@NotNull String datasetID, @NotNull String url, @NotNull String accessKey) {
        Intrinsics.checkNotNullParameter((Object)datasetID, (String)"datasetID");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
        Object[] objectArray = new Object[]{datasetID, url, accessKey};
        Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, " \n\nCloudbridge Configured: \n================\ndatasetID: %s\nurl: %s\naccessKey: %s\n\n", objectArray);
        INSTANCE.setCredentials$facebook_core_release(new CloudBridgeCredentials(datasetID, url, accessKey));
        INSTANCE.setTransformedEvents$facebook_core_release(new ArrayList());
    }

    @JvmStatic
    @Nullable
    public static final String getCredentials() {
        String string;
        try {
            CloudBridgeCredentials cloudBridgeCredentials = INSTANCE.getCredentials$facebook_core_release();
            string = cloudBridgeCredentials != null ? cloudBridgeCredentials.toString() : null;
        }
        catch (UninitializedPropertyAccessException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    public static final void transformGraphRequestAndSendToCAPIGEndPoint(@NotNull GraphRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Utility.runOnNonUiThread(() -> AppEventsConversionsAPITransformerWebRequests.transformGraphRequestAndSendToCAPIGEndPoint$lambda$0(request));
    }

    private final List<Map<String, Object>> transformAppEventRequestForCAPIG(GraphRequest request) {
        JSONObject graphRequestObjJSON = request.getGraphObject();
        if (graphRequestObjJSON != null) {
            Map requestData;
            Map map = requestData = MapsKt.toMutableMap(Utility.convertJSONObjectToHashMap(graphRequestObjJSON));
            Object[] objectArray = "custom_events";
            Object object = request.getTag();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            Object object2 = object;
            map.put(objectArray, object2);
            StringBuilder sb = new StringBuilder();
            for (String key : requestData.keySet()) {
                sb.append(key);
                sb.append(" : ");
                sb.append(requestData.get(key));
                sb.append(System.getProperty("line.separator"));
            }
            objectArray = new Object[]{sb};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "\nGraph Request data: \n\n%s \n\n", objectArray);
            return AppEventsConversionsAPITransformer.INSTANCE.conversionsAPICompatibleEvent$facebook_core_release(requestData);
        }
        return null;
    }

    public final void handleError$facebook_core_release(@Nullable Integer responseCode, @NotNull List<? extends Map<String, ? extends Object>> processedEvents, int maxRetryCount) {
        Intrinsics.checkNotNullParameter(processedEvents, (String)"processedEvents");
        if (CollectionsKt.contains((Iterable)RETRY_EVENTS_HTTP_RESPONSE, (Object)responseCode)) {
            if (currentRetryCount >= maxRetryCount) {
                this.getTransformedEvents$facebook_core_release().clear();
                currentRetryCount = 0;
            } else {
                this.getTransformedEvents$facebook_core_release().addAll(0, (Collection<Map<String, Object>>)processedEvents);
                int n = currentRetryCount;
                currentRetryCount = n + 1;
            }
        }
    }

    public static /* synthetic */ void handleError$facebook_core_release$default(AppEventsConversionsAPITransformerWebRequests appEventsConversionsAPITransformerWebRequests, Integer n, List list, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 5;
        }
        appEventsConversionsAPITransformerWebRequests.handleError$facebook_core_release(n, list, n2);
    }

    public final void appendEvents$facebook_core_release(@Nullable List<? extends Map<String, ? extends Object>> events) {
        int overCacheLimitCount;
        if (events != null) {
            this.getTransformedEvents$facebook_core_release().addAll((Collection<Map<String, Object>>)events);
        }
        if ((overCacheLimitCount = Math.max(0, ((Collection)this.getTransformedEvents$facebook_core_release()).size() - 1000)) > 0) {
            List list = CollectionsKt.drop((Iterable)this.getTransformedEvents$facebook_core_release(), (int)overCacheLimitCount);
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
            this.setTransformedEvents$facebook_core_release(TypeIntrinsics.asMutableList((Object)list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void makeHttpRequest$facebook_core_release(@NotNull String urlStr, @NotNull String requestMethod, @Nullable String jsonBodyStr, @Nullable Map<String, String> requestProperties, int timeOutInterval, @Nullable Function2<? super String, ? super Integer, Unit> requestCallback) {
        Intrinsics.checkNotNullParameter((Object)urlStr, (String)"urlStr");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        try {
            Object[] objectArray;
            URL url = new URL(urlStr);
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(requestMethod);
            Map<String, String> map = requestProperties;
            if (map != null && (map = map.keySet()) != null) {
                Iterable $this$forEach$iv = (Iterable)((Object)map);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String key = (String)element$iv;
                    boolean bl = false;
                    httpURLConnection.setRequestProperty(key, requestProperties.get(key));
                }
            }
            httpURLConnection.setDoOutput(httpURLConnection.getRequestMethod().equals("POST") || httpURLConnection.getRequestMethod().equals("PUT"));
            httpURLConnection.setConnectTimeout(timeOutInterval);
            OutputStream output = new BufferedOutputStream(httpURLConnection.getOutputStream());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            writer.write(jsonBodyStr);
            writer.flush();
            writer.close();
            output.close();
            StringBuilder connResponseSB = new StringBuilder();
            if (ACCEPTABLE_HTTP_RESPONSE.contains(httpURLConnection.getResponseCode())) {
                Closeable closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                objectArray = null;
                try {
                    BufferedReader bufferedReader = (BufferedReader)closeable;
                    boolean bl = false;
                    String line = null;
                    while (true) {
                        String string;
                        String it = string = bufferedReader.readLine();
                        boolean bl2 = false;
                        line = it;
                        if (string == null) break;
                        connResponseSB.append(line);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    objectArray = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray);
                }
            }
            String string = connResponseSB.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connResponseSB.toString()");
            String connResponse = string;
            objectArray = new Object[]{connResponse, httpURLConnection.getResponseCode()};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "\nResponse Received: \n%s\n%s", objectArray);
            if (requestCallback != null) {
                requestCallback.invoke((Object)connResponse, (Object)httpURLConnection.getResponseCode());
            }
        }
        catch (UnknownHostException e) {
            Object[] objectArray = new Object[]{e.toString()};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "Connection failed, retrying: \n%s", objectArray);
            if (requestCallback != null) {
                requestCallback.invoke(null, (Object)503);
            }
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e.toString()};
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Send to server failed: \n%s", objectArray);
        }
    }

    public static /* synthetic */ void makeHttpRequest$facebook_core_release$default(AppEventsConversionsAPITransformerWebRequests appEventsConversionsAPITransformerWebRequests, String string, String string2, String string3, Map map, int n, Function2 function2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 60000;
        }
        appEventsConversionsAPITransformerWebRequests.makeHttpRequest$facebook_core_release(string, string2, string3, map, n, (Function2<? super String, ? super Integer, Unit>)function2);
    }

    private static final void transformGraphRequestAndSendToCAPIGEndPoint$lambda$0(GraphRequest $request) {
        List graphPathComponents;
        List list;
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        String string = $request.getGraphPath();
        if (string != null) {
            String[] stringArray = new String[]{"/"};
            list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list = graphPathComponents = null;
        }
        if (graphPathComponents == null || graphPathComponents.size() != 2) {
            Object[] objectArray = new Object[]{$request};
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "\n GraphPathComponents Error when logging: \n%s", objectArray);
            return;
        }
        String cbEndpoint = null;
        try {
            String cloudBridgeURL = INSTANCE.getCredentials$facebook_core_release().getCloudBridgeURL();
            String datasetID = INSTANCE.getCredentials$facebook_core_release().getDatasetID();
            cbEndpoint = cloudBridgeURL + "/capi/" + datasetID + "/events";
        }
        catch (UninitializedPropertyAccessException e) {
            Object[] datasetID = new Object[]{e};
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "\n Credentials not initialized Error when logging: \n%s", datasetID);
            return;
        }
        List<Map<String, Object>> list2 = INSTANCE.transformAppEventRequestForCAPIG($request);
        if (list2 == null) {
            return;
        }
        List<Map<String, Object>> transformed = list2;
        INSTANCE.appendEvents$facebook_core_release(transformed);
        int eventToProcessCount = Math.min(((Collection)INSTANCE.getTransformedEvents$facebook_core_release()).size(), 10);
        List processedEvents = CollectionsKt.slice(INSTANCE.getTransformedEvents$facebook_core_release(), (IntRange)new IntRange(0, eventToProcessCount - 1));
        INSTANCE.getTransformedEvents$facebook_core_release().subList(0, eventToProcessCount).clear();
        JSONArray jsonArr = new JSONArray((Collection)processedEvents);
        Map jsonMap = new LinkedHashMap();
        jsonMap.put("data", jsonArr);
        jsonMap.put("accessKey", INSTANCE.getCredentials$facebook_core_release().getAccessKey());
        JSONObject jsonBodyStr = new JSONObject(jsonMap);
        Object[] objectArray = new Object[3];
        objectArray[0] = cbEndpoint;
        objectArray[1] = $request;
        Intrinsics.checkNotNullExpressionValue((Object)jsonBodyStr.toString(2), (String)"jsonBodyStr.toString(2)");
        Logger.Companion.log(LoggingBehavior.APP_EVENTS, TAG, "\nTransformed_CAPI_JSON:\nURL: %s\nFROM=========\n%s\n>>>>>>TO>>>>>>\n%s\n=============\n", objectArray);
        INSTANCE.makeHttpRequest$facebook_core_release(cbEndpoint, "POST", jsonBodyStr.toString(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json")), 60000, (Function2<? super String, ? super Integer, Unit>)((Function2)new Function2<String, Integer, Unit>((List<? extends Map<String, ? extends Object>>)processedEvents){
            final /* synthetic */ List<Map<String, Object>> $processedEvents;
            {
                this.$processedEvents = $processedEvents;
                super(2);
            }

            public final void invoke(@Nullable String string, @Nullable Integer responseCode) {
                Utility.runOnNonUiThread(() -> transformGraphRequestAndSendToCAPIGEndPoint.1.1.invoke$lambda$0(responseCode, this.$processedEvents));
            }

            private static final void invoke$lambda$0(Integer $responseCode, List $processedEvents) {
                Intrinsics.checkNotNullParameter((Object)$processedEvents, (String)"$processedEvents");
                if (!CollectionsKt.contains((Iterable)AppEventsConversionsAPITransformerWebRequests.access$getACCEPTABLE_HTTP_RESPONSE$p(), (Object)$responseCode)) {
                    AppEventsConversionsAPITransformerWebRequests.INSTANCE.handleError$facebook_core_release($responseCode, $processedEvents, 5);
                }
            }
        }));
    }

    public static final /* synthetic */ HashSet access$getACCEPTABLE_HTTP_RESPONSE$p() {
        return ACCEPTABLE_HTTP_RESPONSE;
    }

    static {
        Object[] objectArray = new Integer[]{200, 202};
        ACCEPTABLE_HTTP_RESPONSE = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new Integer[]{503, 504, 429};
        RETRY_EVENTS_HTTP_RESPONSE = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/facebook/appevents/cloudbridge/AppEventsConversionsAPITransformerWebRequests$CloudBridgeCredentials;", "", "datasetID", "", "cloudBridgeURL", "accessKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessKey", "()Ljava/lang/String;", "getCloudBridgeURL", "getDatasetID", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "facebook-core_release"})
    public static final class CloudBridgeCredentials {
        @NotNull
        private final String datasetID;
        @NotNull
        private final String cloudBridgeURL;
        @NotNull
        private final String accessKey;

        public CloudBridgeCredentials(@NotNull String datasetID, @NotNull String cloudBridgeURL, @NotNull String accessKey) {
            Intrinsics.checkNotNullParameter((Object)datasetID, (String)"datasetID");
            Intrinsics.checkNotNullParameter((Object)cloudBridgeURL, (String)"cloudBridgeURL");
            Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
            this.datasetID = datasetID;
            this.cloudBridgeURL = cloudBridgeURL;
            this.accessKey = accessKey;
        }

        @NotNull
        public final String getDatasetID() {
            return this.datasetID;
        }

        @NotNull
        public final String getCloudBridgeURL() {
            return this.cloudBridgeURL;
        }

        @NotNull
        public final String getAccessKey() {
            return this.accessKey;
        }

        @NotNull
        public final String component1() {
            return this.datasetID;
        }

        @NotNull
        public final String component2() {
            return this.cloudBridgeURL;
        }

        @NotNull
        public final String component3() {
            return this.accessKey;
        }

        @NotNull
        public final CloudBridgeCredentials copy(@NotNull String datasetID, @NotNull String cloudBridgeURL, @NotNull String accessKey) {
            Intrinsics.checkNotNullParameter((Object)datasetID, (String)"datasetID");
            Intrinsics.checkNotNullParameter((Object)cloudBridgeURL, (String)"cloudBridgeURL");
            Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
            return new CloudBridgeCredentials(datasetID, cloudBridgeURL, accessKey);
        }

        public static /* synthetic */ CloudBridgeCredentials copy$default(CloudBridgeCredentials cloudBridgeCredentials, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = cloudBridgeCredentials.datasetID;
            }
            if ((n & 2) != 0) {
                string2 = cloudBridgeCredentials.cloudBridgeURL;
            }
            if ((n & 4) != 0) {
                string3 = cloudBridgeCredentials.accessKey;
            }
            return cloudBridgeCredentials.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "CloudBridgeCredentials(datasetID=" + this.datasetID + ", cloudBridgeURL=" + this.cloudBridgeURL + ", accessKey=" + this.accessKey + ')';
        }

        public int hashCode() {
            int result = this.datasetID.hashCode();
            result = result * 31 + this.cloudBridgeURL.hashCode();
            result = result * 31 + this.accessKey.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CloudBridgeCredentials)) {
                return false;
            }
            CloudBridgeCredentials cloudBridgeCredentials = (CloudBridgeCredentials)other;
            if (!Intrinsics.areEqual((Object)this.datasetID, (Object)cloudBridgeCredentials.datasetID)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cloudBridgeURL, (Object)cloudBridgeCredentials.cloudBridgeURL)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.accessKey, (Object)cloudBridgeCredentials.accessKey);
        }
    }
}

