/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.appevents.iap.InAppPurchaseEventManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001dj\b\u0012\u0004\u0012\u00020\u0004`\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010!\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseActivityLifecycleTracker;", "", "()V", "BILLING_ACTIVITY_NAME", "", "SERVICE_INTERFACE_NAME", "TAG", "kotlin.jvm.PlatformType", "billingClientVersion", "Lcom/facebook/appevents/iap/InAppPurchaseUtils$BillingClientVersion;", "callbacks", "Landroid/app/Application$ActivityLifecycleCallbacks;", "hasBillingActivity", "", "Ljava/lang/Boolean;", "hasBillingService", "inAppBillingObj", "intent", "Landroid/content/Intent;", "isTracking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serviceConnection", "Landroid/content/ServiceConnection;", "initializeIfNotInitialized", "", "logPurchase", "context", "Landroid/content/Context;", "purchases", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isSubscription", "startIapLogging", "startTracking", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppPurchaseActivityLifecycleTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppPurchaseActivityLifecycleTracker.kt\ncom/facebook/appevents/iap/InAppPurchaseActivityLifecycleTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class InAppPurchaseActivityLifecycleTracker {
    @NotNull
    public static final InAppPurchaseActivityLifecycleTracker INSTANCE = new InAppPurchaseActivityLifecycleTracker();
    private static final String TAG = InAppPurchaseActivityLifecycleTracker.class.getCanonicalName();
    @NotNull
    private static final String SERVICE_INTERFACE_NAME = "com.android.vending.billing.IInAppBillingService$Stub";
    @NotNull
    private static final String BILLING_ACTIVITY_NAME = "com.android.billingclient.api.ProxyBillingActivity";
    @NotNull
    private static final AtomicBoolean isTracking = new AtomicBoolean(false);
    @Nullable
    private static Boolean hasBillingService;
    @Nullable
    private static Boolean hasBillingActivity;
    private static ServiceConnection serviceConnection;
    private static Application.ActivityLifecycleCallbacks callbacks;
    private static Intent intent;
    @Nullable
    private static Object inAppBillingObj;
    @Nullable
    private static InAppPurchaseUtils.BillingClientVersion billingClientVersion;

    private InAppPurchaseActivityLifecycleTracker() {
    }

    @JvmStatic
    public static final void startIapLogging(@NotNull InAppPurchaseUtils.BillingClientVersion billingClientVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)billingClientVersion), (String)"billingClientVersion");
        INSTANCE.initializeIfNotInitialized();
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            InAppPurchaseActivityLifecycleTracker.billingClientVersion = billingClientVersion;
            INSTANCE.startTracking();
        }
    }

    private final void initializeIfNotInitialized() {
        if (hasBillingService != null) {
            return;
        }
        hasBillingService = InAppPurchaseUtils.getClass(SERVICE_INTERFACE_NAME) != null;
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        hasBillingActivity = InAppPurchaseUtils.getClass(BILLING_ACTIVITY_NAME) != null;
        InAppPurchaseEventManager.clearSkuDetailsCache();
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(\"com.android.vend\u2026ge(\"com.android.vending\")");
        InAppPurchaseActivityLifecycleTracker.intent = intent;
        serviceConnection = new ServiceConnection(){

            public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                InAppPurchaseActivityLifecycleTracker.access$setInAppBillingObj$p(InAppPurchaseEventManager.asInterface(FacebookSdk.getApplicationContext(), service));
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }
        };
        callbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    FacebookSdk.getExecutor().execute(initializeIfNotInitialized.2::onActivityResumed$lambda$0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    if (Intrinsics.areEqual((Object)InAppPurchaseActivityLifecycleTracker.access$getHasBillingActivity$p(), (Object)true) && Intrinsics.areEqual((Object)activity.getLocalClassName(), (Object)"com.android.billingclient.api.ProxyBillingActivity")) {
                        FacebookSdk.getExecutor().execute(initializeIfNotInitialized.2::onActivityStopped$lambda$1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            private static final void onActivityResumed$lambda$0() {
                Context context = FacebookSdk.getApplicationContext();
                ArrayList<String> purchasesInapp = InAppPurchaseEventManager.getPurchasesInapp(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                InAppPurchaseActivityLifecycleTracker.access$logPurchase(InAppPurchaseActivityLifecycleTracker.INSTANCE, context, purchasesInapp, false);
                ArrayList<String> purchasesSubs = InAppPurchaseEventManager.getPurchasesSubs(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                InAppPurchaseActivityLifecycleTracker.access$logPurchase(InAppPurchaseActivityLifecycleTracker.INSTANCE, context, purchasesSubs, true);
            }

            private static final void onActivityStopped$lambda$1() {
                Context context = FacebookSdk.getApplicationContext();
                ArrayList<String> purchases = InAppPurchaseEventManager.getPurchasesInapp(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                if (purchases.isEmpty()) {
                    purchases = InAppPurchaseEventManager.getPurchaseHistoryInapp(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                }
                InAppPurchaseActivityLifecycleTracker.access$logPurchase(InAppPurchaseActivityLifecycleTracker.INSTANCE, context, purchases, false);
            }
        };
    }

    private final void startTracking() {
        if (!isTracking.compareAndSet(false, true)) {
            return;
        }
        Context context = FacebookSdk.getApplicationContext();
        if (context instanceof Application) {
            ServiceConnection serviceConnection;
            Application application = (Application)context;
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = callbacks;
            if (activityLifecycleCallbacks == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"callbacks");
                activityLifecycleCallbacks = null;
            }
            application.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
            Intent intent = InAppPurchaseActivityLifecycleTracker.intent;
            if (intent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"intent");
                intent = null;
            }
            if ((serviceConnection = InAppPurchaseActivityLifecycleTracker.serviceConnection) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceConnection");
                serviceConnection = null;
            }
            context.bindService(intent, serviceConnection, 1);
        }
    }

    private final void logPurchase(Context context, ArrayList<String> purchases, boolean isSubscription) {
        if (purchases.isEmpty()) {
            return;
        }
        HashMap purchaseMap = new HashMap();
        ArrayList<String> skuList = new ArrayList<String>();
        for (String purchase : purchases) {
            try {
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                Map map = purchaseMap;
                Intrinsics.checkNotNullExpressionValue((Object)sku, (String)"sku");
                Intrinsics.checkNotNullExpressionValue((Object)purchase, (String)"purchase");
                map.put(sku, purchase);
                skuList.add(sku);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
            }
        }
        Map<String, String> skuDetailsMap = InAppPurchaseEventManager.getSkuDetails(context, skuList, inAppBillingObj, isSubscription);
        for (Map.Entry<String, String> entry : skuDetailsMap.entrySet()) {
            String it;
            String key = entry.getKey();
            String value = entry.getValue();
            if ((String)purchaseMap.get(key) == null) continue;
            boolean bl = false;
            AutomaticAnalyticsLogger.logPurchase$default(it, value, isSubscription, billingClientVersion, false, 16, null);
        }
    }

    public static final /* synthetic */ void access$setInAppBillingObj$p(Object object) {
        inAppBillingObj = object;
    }

    public static final /* synthetic */ Boolean access$getHasBillingActivity$p() {
        return hasBillingActivity;
    }

    public static final /* synthetic */ Object access$getInAppBillingObj$p() {
        return inAppBillingObj;
    }

    public static final /* synthetic */ void access$logPurchase(InAppPurchaseActivityLifecycleTracker $this, Context context, ArrayList purchases, boolean isSubscription) {
        $this.logPurchase(context, purchases, isSubscription);
    }
}

