/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.AppLinkManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/facebook/appevents/internal/AppLinkManager;", "", "()V", "preferences", "Landroid/content/SharedPreferences;", "getPreferences", "()Landroid/content/SharedPreferences;", "preferences$delegate", "Lkotlin/Lazy;", "getCampaignIDFromIntentExtra", "", "intent", "Landroid/content/Intent;", "getCampaignIDFromUri", "uri", "Landroid/net/Uri;", "getInfo", "key", "handleURL", "", "activity", "Landroid/app/Activity;", "processCampaignIds", "setupLifecycleListener", "application", "Landroid/app/Application;", "Companion", "facebook-core_release"})
public final class AppLinkManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy preferences$delegate = LazyKt.lazy((Function0)preferences.2.INSTANCE);
    @NotNull
    public static final String APPLINK_INFO = "com.facebook.sdk.APPLINK_INFO";
    @NotNull
    public static final String APPLINK_DATA_KEY = "al_applink_data";
    @NotNull
    public static final String CAMPAIGN_IDS_KEY = "campaign_ids";
    @Nullable
    private static volatile AppLinkManager instance;

    private AppLinkManager() {
    }

    private final SharedPreferences getPreferences() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            Lazy lazy = this.preferences$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-preferences>(...)");
            return (SharedPreferences)object;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handleURL(@NotNull Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            Uri uri = activity2.getIntent().getData();
            if (uri == null) {
                return;
            }
            Uri uri2 = uri;
            Intent intent = activity2.getIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"activity.intent");
            this.processCampaignIds(uri2, intent);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processCampaignIds(@NotNull Uri uri, @NotNull Intent intent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            String campaignIDs;
            void intent2;
            void uri2;
            Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
            String string = this.getCampaignIDFromUri((Uri)uri2);
            if (string == null) {
                string = this.getCampaignIDFromIntentExtra((Intent)intent2);
            }
            if ((campaignIDs = string) != null) {
                this.getPreferences().edit().putString(CAMPAIGN_IDS_KEY, campaignIDs).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getCampaignIDFromUri(@NotNull Uri uri) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void uri2;
            Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
            String string = uri2.getQueryParameter(APPLINK_DATA_KEY);
            if (string == null) {
                return null;
            }
            String applinkData = string;
            try {
                JSONObject json = new JSONObject(applinkData);
                return json.getString(CAMPAIGN_IDS_KEY);
            }
            catch (Exception _) {
                Log.d((String)"AppLinkManager", (String)"Fail to parse Applink data from Uri");
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getCampaignIDFromIntentExtra(@NotNull Intent intent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void intent2;
            Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
            Bundle bundle = intent2.getBundleExtra(APPLINK_DATA_KEY);
            if (bundle == null) {
                return null;
            }
            Bundle applinkBundle = bundle;
            return applinkBundle.getString(CAMPAIGN_IDS_KEY);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getInfo(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void key;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getPreferences().getString((String)key, null);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setupLifecycleListener(@NotNull Application application) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void application2;
            Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
            application2.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                }

                public void onActivityStarted(@NotNull Activity activity) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        AppLinkManager appLinkManager = AppLinkManager.Companion.getInstance();
                        if (appLinkManager == null) break block0;
                        appLinkManager.handleURL(activity);
                    }
                }

                public void onActivityResumed(@NotNull Activity activity) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        AppLinkManager appLinkManager = AppLinkManager.Companion.getInstance();
                        if (appLinkManager == null) break block0;
                        appLinkManager.handleURL(activity);
                    }
                }

                public void onActivityPaused(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                }

                public void onActivityStopped(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                }

                public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle bundle) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                }

                public void onActivityDestroyed(@NotNull Activity activity) {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static final /* synthetic */ AppLinkManager access$getInstance$cp() {
        if (CrashShieldHandler.isObjectCrashing(AppLinkManager.class)) {
            return null;
        }
        try {
            return instance;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppLinkManager.class);
            return null;
        }
    }

    public static final /* synthetic */ void access$setInstance$cp(AppLinkManager appLinkManager) {
        if (CrashShieldHandler.isObjectCrashing(AppLinkManager.class)) {
            return;
        }
        try {
            AppLinkManager appLinkManager2;
            instance = appLinkManager2;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppLinkManager.class);
            return;
        }
    }

    public /* synthetic */ AppLinkManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/appevents/internal/AppLinkManager$Companion;", "", "()V", "APPLINK_DATA_KEY", "", "APPLINK_INFO", "CAMPAIGN_IDS_KEY", "instance", "Lcom/facebook/appevents/internal/AppLinkManager;", "getInstance", "facebook-core_release"})
    @SourceDebugExtension(value={"SMAP\nAppLinkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkManager.kt\ncom/facebook/appevents/internal/AppLinkManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final AppLinkManager getInstance() {
            AppLinkManager appLinkManager = AppLinkManager.access$getInstance$cp();
            if (appLinkManager == null) {
                Companion companion = this;
                synchronized (companion) {
                    block6: {
                        boolean bl = false;
                        if (FacebookSdk.isInitialized()) break block6;
                        AppLinkManager appLinkManager2 = null;
                        return appLinkManager2;
                    }
                    AppLinkManager appLinkManager3 = AppLinkManager.access$getInstance$cp();
                    if (appLinkManager3 == null) {
                        AppLinkManager appLinkManager4;
                        AppLinkManager it = appLinkManager4 = new AppLinkManager(null);
                        boolean bl = false;
                        AppLinkManager.access$setInstance$cp(it);
                        appLinkManager3 = appLinkManager4;
                    }
                    AppLinkManager appLinkManager5 = appLinkManager3;
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var1_1
                    appLinkManager = appLinkManager5;
                }
            }
            return appLinkManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

