/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.internal.FacebookRequestErrorClassification;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002efB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u000207H\u0007J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0004H\u0002J\u0014\u0010F\u001a\u0004\u0018\u0001042\b\u0010E\u001a\u0004\u0018\u00010\u0004H\u0007J\u0016\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000209\u0018\u00010HH\u0007J\b\u0010I\u001a\u00020AH\u0007J\u001d\u0010J\u001a\u0002042\u0006\u0010E\u001a\u00020\u00042\u0006\u0010K\u001a\u00020DH\u0000\u00a2\u0006\u0002\bLJ\"\u0010M\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00102\b\u0010N\u001a\u0004\u0018\u00010D2\u0006\u0010O\u001a\u00020\u0004H\u0002JT\u0010P\u001a:\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100R\u0018\u00010Qj\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100R\u0018\u0001`S2\b\u0010N\u001a\u0004\u0018\u00010D2\b\b\u0002\u0010T\u001a\u000209H\u0002J\u0019\u0010U\u001a\u0004\u0018\u00010V2\b\u0010W\u001a\u0004\u0018\u00010DH\u0002\u00a2\u0006\u0002\u0010XJ*\u0010Y\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020Z030H2\b\u0010[\u001a\u0004\u0018\u00010DH\u0002J \u0010\\\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000209\u0018\u00010H2\b\u0010K\u001a\u0004\u0018\u00010DH\u0002J\u001c\u0010]\u001a\u0004\u0018\u00010?2\b\u0010^\u001a\u0004\u0018\u00010D2\u0006\u0010_\u001a\u00020\u0004H\u0002J\b\u0010`\u001a\u00020AH\u0002J\u001a\u0010a\u001a\u0004\u0018\u0001042\u0006\u0010E\u001a\u00020\u00042\u0006\u0010b\u001a\u000209H\u0007J\u0010\u0010c\u001a\u00020A2\u0006\u0010d\u001a\u000209H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n .*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0010\u0012\f\u0012\n .*\u0004\u0018\u00010<0<0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager;", "", "()V", "ANDROID_DEDUPE_KEY", "", "APPLICATION_FIELDS", "APP_SETTINGS_PREFS_KEY_FORMAT", "APP_SETTINGS_PREFS_STORE", "APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES", "APP_SETTING_APP_EVENTS_AAM_RULE", "APP_SETTING_APP_EVENTS_CONFIG", "APP_SETTING_APP_EVENTS_EVENT_BINDINGS", "APP_SETTING_APP_EVENTS_FEATURE_BITMASK", "APP_SETTING_APP_EVENTS_SESSION_TIMEOUT", "APP_SETTING_DIALOG_CONFIGS", "APP_SETTING_FIELDS", "", "APP_SETTING_NUX_CONTENT", "APP_SETTING_NUX_ENABLED", "APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD", "APP_SETTING_SMART_LOGIN_OPTIONS", "APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING", "AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD", "", "AUTO_LOG_APP_EVENTS_DEFAULT_FIELD", "AUTO_LOG_APP_EVENT_ENABLED_FIELD", "BLOCKLIST_EVENTS_KEY", "CODELESS_EVENTS_ENABLED_BITMASK_FIELD", "DEDUPE_KEY", "DEDUPE_WINDOW", "IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD", "KEY", "MACA_RULES_KEY", "MONITOR_ENABLED_BITMASK_FIELD", "PROD_DEDUPE_KEY", "PROTECTED_MODE_RULES", "REDACTED_EVENTS_KEY", "SDK_UPDATE_MESSAGE", "SENSITIVE_PARAMS_KEY", "SMART_LOGIN_BOOKMARK_ICON_URL", "SMART_LOGIN_MENU_ICON_URL", "STANDARD_PARAMS_KEY", "STD_PARAMS_BLOCKED_KEY", "STD_PARAMS_SCHEMA_KEY", "SUGGESTED_EVENTS_SETTING", "TAG", "kotlin.jvm.PlatformType", "TEST_DEDUPE_KEY", "TRACK_UNINSTALL_ENABLED_BITMASK_FIELD", "VALUE", "fetchedAppSettings", "", "Lcom/facebook/internal/FetchedAppSettings;", "fetchedAppSettingsCallbacks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/facebook/internal/FetchedAppSettingsManager$FetchedAppSettingsCallback;", "isUnityInit", "", "loadingState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/facebook/internal/FetchedAppSettingsManager$FetchAppSettingState;", "printedSDKUpdatedMessage", "unityEventBindings", "Lorg/json/JSONArray;", "getAppSettingsAsync", "", "callback", "getAppSettingsQueryResponse", "Lorg/json/JSONObject;", "applicationId", "getAppSettingsWithoutQuery", "getCachedMigratedAutoLogValuesInAppSettings", "", "loadAppSettingsAsync", "parseAppSettingsFromJSON", "settingsJSON", "parseAppSettingsFromJSON$facebook_core_release", "parseCurrencyAndValueDedupeParameters", "originalJSON", "key", "parseDedupeParameters", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lkotlin/collections/ArrayList;", "getTestValues", "parseDedupeWindow", "", "parameters", "(Lorg/json/JSONObject;)Ljava/lang/Long;", "parseDialogConfigurations", "Lcom/facebook/internal/FetchedAppSettings$DialogFeatureConfig;", "dialogConfigResponse", "parseMigratedAutoLogValues", "parseProtectedModeRules", "protectedModeSettings", "ruleType", "pollCallbacks", "queryAppSettings", "forceRequery", "setIsUnityInit", "flag", "FetchAppSettingState", "FetchedAppSettingsCallback", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nFetchedAppSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchedAppSettingsManager.kt\ncom/facebook/internal/FetchedAppSettingsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,564:1\n1#2:565\n*E\n"})
public final class FetchedAppSettingsManager {
    @NotNull
    public static final FetchedAppSettingsManager INSTANCE = new FetchedAppSettingsManager();
    private static final String TAG = FetchedAppSettingsManager.class.getSimpleName();
    @NotNull
    private static final String APP_SETTINGS_PREFS_STORE = "com.facebook.internal.preferences.APP_SETTINGS";
    @NotNull
    private static final String APP_SETTINGS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_SETTINGS.%s";
    @NotNull
    private static final String APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING = "supports_implicit_sdk_logging";
    @NotNull
    private static final String APP_SETTING_NUX_CONTENT = "gdpv4_nux_content";
    @NotNull
    private static final String APP_SETTING_NUX_ENABLED = "gdpv4_nux_enabled";
    @NotNull
    private static final String APP_SETTING_DIALOG_CONFIGS = "android_dialog_configs";
    @NotNull
    private static final String APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES = "android_sdk_error_categories";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_SESSION_TIMEOUT = "app_events_session_timeout";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_FEATURE_BITMASK = "app_events_feature_bitmask";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_EVENT_BINDINGS = "auto_event_mapping_android";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_CONFIG = "app_events_config";
    @NotNull
    private static final String APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD = "restrictive_data_filter_params";
    private static final int AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 8;
    private static final int IAP_AUTOMATIC_LOGGING_ENABLED_BITMASK_FIELD = 16;
    private static final int CODELESS_EVENTS_ENABLED_BITMASK_FIELD = 32;
    private static final int TRACK_UNINSTALL_ENABLED_BITMASK_FIELD = 256;
    private static final int MONITOR_ENABLED_BITMASK_FIELD = 16384;
    @NotNull
    private static final String APP_SETTING_SMART_LOGIN_OPTIONS = "seamless_login";
    @NotNull
    private static final String SMART_LOGIN_BOOKMARK_ICON_URL = "smart_login_bookmark_icon_url";
    @NotNull
    private static final String SMART_LOGIN_MENU_ICON_URL = "smart_login_menu_icon_url";
    @NotNull
    private static final String SDK_UPDATE_MESSAGE = "sdk_update_message";
    @NotNull
    private static final String APP_SETTING_APP_EVENTS_AAM_RULE = "aam_rules";
    @NotNull
    private static final String SUGGESTED_EVENTS_SETTING = "suggested_events_setting";
    @NotNull
    private static final String PROTECTED_MODE_RULES = "protected_mode_rules";
    @NotNull
    private static final String STANDARD_PARAMS_KEY = "standard_params";
    @NotNull
    private static final String MACA_RULES_KEY = "maca_rules";
    @NotNull
    private static final String BLOCKLIST_EVENTS_KEY = "blocklist_events";
    @NotNull
    private static final String REDACTED_EVENTS_KEY = "redacted_events";
    @NotNull
    private static final String SENSITIVE_PARAMS_KEY = "sensitive_params";
    @NotNull
    private static final String DEDUPE_KEY = "iap_manual_and_auto_log_dedup_keys";
    @NotNull
    private static final String ANDROID_DEDUPE_KEY = "FBAndroidSDK";
    @NotNull
    private static final String PROD_DEDUPE_KEY = "prod_keys";
    @NotNull
    private static final String TEST_DEDUPE_KEY = "test_keys";
    @NotNull
    private static final String KEY = "key";
    @NotNull
    private static final String VALUE = "value";
    @NotNull
    private static final String DEDUPE_WINDOW = "iap_manual_and_auto_log_dedup_window_millis";
    @NotNull
    private static final String STD_PARAMS_SCHEMA_KEY = "standard_params_schema";
    @NotNull
    private static final String STD_PARAMS_BLOCKED_KEY = "standard_params_blocked";
    @NotNull
    public static final String AUTO_LOG_APP_EVENTS_DEFAULT_FIELD = "auto_log_app_events_default";
    @NotNull
    public static final String AUTO_LOG_APP_EVENT_ENABLED_FIELD = "auto_log_app_events_enabled";
    @NotNull
    private static final List<String> APP_SETTING_FIELDS;
    @NotNull
    private static final String APPLICATION_FIELDS = "fields";
    @NotNull
    private static final Map<String, FetchedAppSettings> fetchedAppSettings;
    @NotNull
    private static final AtomicReference<FetchAppSettingState> loadingState;
    @NotNull
    private static final ConcurrentLinkedQueue<FetchedAppSettingsCallback> fetchedAppSettingsCallbacks;
    private static boolean printedSDKUpdatedMessage;
    private static boolean isUnityInit;
    @Nullable
    private static JSONArray unityEventBindings;

    private FetchedAppSettingsManager() {
    }

    @JvmStatic
    public static final void loadAppSettingsAsync() {
        boolean canStartLoading;
        Context context = FacebookSdk.getApplicationContext();
        String applicationId = FacebookSdk.getApplicationId();
        if (Utility.isNullOrEmpty(applicationId)) {
            loadingState.set(FetchAppSettingState.ERROR);
            INSTANCE.pollCallbacks();
            return;
        }
        if (fetchedAppSettings.containsKey(applicationId)) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            INSTANCE.pollCallbacks();
            return;
        }
        boolean bl = canStartLoading = loadingState.compareAndSet(FetchAppSettingState.NOT_LOADED, FetchAppSettingState.LOADING) || loadingState.compareAndSet(FetchAppSettingState.ERROR, FetchAppSettingState.LOADING);
        if (!canStartLoading) {
            INSTANCE.pollCallbacks();
            return;
        }
        String string = APP_SETTINGS_PREFS_KEY_FORMAT;
        Object[] objectArray = new Object[]{applicationId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String settingsKey = string2;
        FacebookSdk.getExecutor().execute(() -> FetchedAppSettingsManager.loadAppSettingsAsync$lambda$0(context, settingsKey, applicationId));
    }

    @JvmStatic
    @Nullable
    public static final FetchedAppSettings getAppSettingsWithoutQuery(@Nullable String applicationId) {
        String string = applicationId;
        return string != null ? fetchedAppSettings.get(string) : null;
    }

    @JvmStatic
    public static final void getAppSettingsAsync(@NotNull FetchedAppSettingsCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        fetchedAppSettingsCallbacks.add(callback2);
        INSTANCE.loadAppSettingsAsync();
    }

    private final synchronized void pollCallbacks() {
        FetchAppSettingState currentState = loadingState.get();
        if (FetchAppSettingState.NOT_LOADED == currentState || FetchAppSettingState.LOADING == currentState) {
            return;
        }
        String applicationId = FacebookSdk.getApplicationId();
        FetchedAppSettings appSettings = fetchedAppSettings.get(applicationId);
        Handler handler = new Handler(Looper.getMainLooper());
        if (FetchAppSettingState.ERROR == currentState) {
            while (!fetchedAppSettingsCallbacks.isEmpty()) {
                FetchedAppSettingsCallback callback2 = fetchedAppSettingsCallbacks.poll();
                handler.post(() -> FetchedAppSettingsManager.pollCallbacks$lambda$1(callback2));
            }
            return;
        }
        while (!fetchedAppSettingsCallbacks.isEmpty()) {
            FetchedAppSettingsCallback callback3 = fetchedAppSettingsCallbacks.poll();
            handler.post(() -> FetchedAppSettingsManager.pollCallbacks$lambda$2(callback3, appSettings));
        }
    }

    @JvmStatic
    @Nullable
    public static final Map<String, Boolean> getCachedMigratedAutoLogValuesInAppSettings() {
        Context context = FacebookSdk.getApplicationContext();
        String applicationId = FacebookSdk.getApplicationId();
        String string = APP_SETTINGS_PREFS_KEY_FORMAT;
        Object object = new Object[]{applicationId};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String settingsKey = string2;
        SharedPreferences sharedPrefs = context.getSharedPreferences(APP_SETTINGS_PREFS_STORE, 0);
        String settingsJSONString = sharedPrefs.getString(settingsKey, null);
        if (!Utility.isNullOrEmpty(settingsJSONString)) {
            if (settingsJSONString == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            JSONObject settingsJSON = null;
            try {
                settingsJSON = new JSONObject(settingsJSONString);
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
            JSONObject jSONObject = settingsJSON;
            if (jSONObject != null) {
                JSONObject it = jSONObject;
                boolean bl = false;
                return INSTANCE.parseMigratedAutoLogValues(settingsJSON);
            }
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final FetchedAppSettings queryAppSettings(@NotNull String applicationId, boolean forceRequery) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        if (!forceRequery && fetchedAppSettings.containsKey(applicationId)) {
            return fetchedAppSettings.get(applicationId);
        }
        JSONObject response = INSTANCE.getAppSettingsQueryResponse(applicationId);
        FetchedAppSettings fetchedAppSettings = INSTANCE.parseAppSettingsFromJSON$facebook_core_release(applicationId, response);
        if (Intrinsics.areEqual((Object)applicationId, (Object)FacebookSdk.getApplicationId())) {
            loadingState.set(FetchAppSettingState.SUCCESS);
            INSTANCE.pollCallbacks();
        }
        return fetchedAppSettings;
    }

    @NotNull
    public final FetchedAppSettings parseAppSettingsFromJSON$facebook_core_release(@NotNull String applicationId, @NotNull JSONObject settingsJSON) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)settingsJSON, (String)"settingsJSON");
        JSONArray errorClassificationJSON = settingsJSON.optJSONArray(APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES);
        FacebookRequestErrorClassification facebookRequestErrorClassification = FacebookRequestErrorClassification.Companion.createFromJSON(errorClassificationJSON);
        if (facebookRequestErrorClassification == null) {
            facebookRequestErrorClassification = FacebookRequestErrorClassification.Companion.getDefaultErrorClassification();
        }
        FacebookRequestErrorClassification errorClassification = facebookRequestErrorClassification;
        int featureBitmask = settingsJSON.optInt(APP_SETTING_APP_EVENTS_FEATURE_BITMASK, 0);
        boolean automaticLoggingEnabled = (featureBitmask & 8) != 0;
        boolean inAppPurchaseAutomaticLoggingEnabled = (featureBitmask & 0x10) != 0;
        boolean codelessEventsEnabled = (featureBitmask & 0x20) != 0;
        boolean trackUninstallEnabled = (featureBitmask & 0x100) != 0;
        boolean monitorEnabled = (featureBitmask & 0x4000) != 0;
        JSONArray eventBindings = settingsJSON.optJSONArray(APP_SETTING_APP_EVENTS_EVENT_BINDINGS);
        unityEventBindings = eventBindings;
        if (unityEventBindings != null && InternalSettings.isUnityApp()) {
            JSONArray jSONArray = eventBindings;
            UnityReflection.sendEventMapping(jSONArray != null ? jSONArray.toString() : null);
        }
        JSONObject appEventsConfig = settingsJSON.optJSONObject(APP_SETTING_APP_EVENTS_CONFIG);
        boolean bl = settingsJSON.optBoolean(APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, false);
        String string = settingsJSON.optString(APP_SETTING_NUX_CONTENT, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsJSON.optString(A\u2026_SETTING_NUX_CONTENT, \"\")");
        boolean bl2 = settingsJSON.optBoolean(APP_SETTING_NUX_ENABLED, false);
        int n = settingsJSON.optInt(APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, Constants.getDefaultAppEventsSessionTimeoutInSeconds());
        EnumSet<SmartLoginOption> enumSet = SmartLoginOption.Companion.parseOptions(settingsJSON.optLong(APP_SETTING_SMART_LOGIN_OPTIONS));
        Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> map = this.parseDialogConfigurations(settingsJSON.optJSONObject(APP_SETTING_DIALOG_CONFIGS));
        String string2 = settingsJSON.optString(SMART_LOGIN_BOOKMARK_ICON_URL);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"settingsJSON.optString(S\u2026_LOGIN_BOOKMARK_ICON_URL)");
        String string3 = settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"settingsJSON.optString(SMART_LOGIN_MENU_ICON_URL)");
        String string4 = settingsJSON.optString(SDK_UPDATE_MESSAGE);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"settingsJSON.optString(SDK_UPDATE_MESSAGE)");
        FetchedAppSettings result = new FetchedAppSettings(bl, string, bl2, n, enumSet, map, automaticLoggingEnabled, errorClassification, string2, string3, inAppPurchaseAutomaticLoggingEnabled, codelessEventsEnabled, eventBindings, string4, trackUninstallEnabled, monitorEnabled, settingsJSON.optString(APP_SETTING_APP_EVENTS_AAM_RULE), settingsJSON.optString(SUGGESTED_EVENTS_SETTING), settingsJSON.optString(APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), STANDARD_PARAMS_KEY), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), MACA_RULES_KEY), this.parseMigratedAutoLogValues(settingsJSON), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), BLOCKLIST_EVENTS_KEY), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), REDACTED_EVENTS_KEY), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), SENSITIVE_PARAMS_KEY), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), STD_PARAMS_SCHEMA_KEY), this.parseProtectedModeRules(settingsJSON.optJSONObject(PROTECTED_MODE_RULES), STD_PARAMS_BLOCKED_KEY), this.parseCurrencyAndValueDedupeParameters(appEventsConfig, "fb_currency"), this.parseCurrencyAndValueDedupeParameters(appEventsConfig, "_valueToSum"), FetchedAppSettingsManager.parseDedupeParameters$default(this, appEventsConfig, false, 2, null), (List<? extends Pair<String, ? extends List<String>>>)this.parseDedupeParameters(appEventsConfig, true), this.parseDedupeWindow(settingsJSON.optJSONObject(APP_SETTING_APP_EVENTS_CONFIG)));
        fetchedAppSettings.put(applicationId, result);
        return result;
    }

    @JvmStatic
    public static final void setIsUnityInit(boolean flag) {
        isUnityInit = flag;
        if (unityEventBindings != null && isUnityInit) {
            UnityReflection.sendEventMapping(String.valueOf(unityEventBindings));
        }
    }

    private final JSONObject getAppSettingsQueryResponse(String applicationId) {
        List list;
        Bundle appSettingsParams = new Bundle();
        List $this$getAppSettingsQueryResponse_u24lambda_u244 = list = (List)new ArrayList();
        boolean bl = false;
        $this$getAppSettingsQueryResponse_u24lambda_u244.addAll((Collection)APP_SETTING_FIELDS);
        List appSettingFields = list;
        appSettingsParams.putString(APPLICATION_FIELDS, TextUtils.join((CharSequence)",", (Iterable)appSettingFields));
        GraphRequest request = GraphRequest.Companion.newGraphPathRequest(null, "app", null);
        request.setForceApplicationRequest(true);
        request.setParameters(appSettingsParams);
        JSONObject jSONObject = request.executeAndWait().getJsonObject();
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    private final Map<String, Map<String, FetchedAppSettings.DialogFeatureConfig>> parseDialogConfigurations(JSONObject dialogConfigResponse) {
        JSONArray dialogConfigData;
        HashMap dialogConfigMap = new HashMap();
        if (dialogConfigResponse != null && (dialogConfigData = dialogConfigResponse.optJSONArray("data")) != null) {
            int n = dialogConfigData.length();
            for (int i = 0; i < n; ++i) {
                FetchedAppSettings.DialogFeatureConfig dialogConfig;
                JSONObject jSONObject = dialogConfigData.optJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"dialogConfigData.optJSONObject(i)");
                if (FetchedAppSettings.DialogFeatureConfig.Companion.parseDialogConfig(jSONObject) == null) continue;
                String dialogName = dialogConfig.getDialogName();
                Map featureMap = (Map)dialogConfigMap.get(dialogName);
                if (featureMap == null) {
                    featureMap = new HashMap();
                    ((Map)dialogConfigMap).put(dialogName, featureMap);
                }
                featureMap.put(dialogConfig.getFeatureName(), dialogConfig);
            }
        }
        return dialogConfigMap;
    }

    private final Long parseDedupeWindow(JSONObject parameters) {
        try {
            JSONObject jSONObject = parameters;
            return jSONObject != null ? Long.valueOf(jSONObject.optLong(DEDUPE_WINDOW)) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final JSONArray parseProtectedModeRules(JSONObject protectedModeSettings, String ruleType) {
        JSONArray rule = null;
        if (protectedModeSettings != null) {
            rule = protectedModeSettings.optJSONArray(ruleType);
        }
        return rule;
    }

    private final List<String> parseCurrencyAndValueDedupeParameters(JSONObject originalJSON, String key) {
        try {
            ArrayList resultList = null;
            JSONObject jSONObject = originalJSON;
            Object object = jSONObject != null ? jSONObject.getJSONArray(DEDUPE_KEY) : null;
            if (object == null) {
                return null;
            }
            JSONArray dedupeConfigs = object;
            int n = dedupeConfigs.length();
            for (int index = 0; index < n; ++index) {
                JSONObject config = dedupeConfigs.getJSONObject(index);
                String configKey = config.getString(KEY);
                if (!Intrinsics.areEqual((Object)configKey, (Object)PROD_DEDUPE_KEY)) continue;
                JSONArray configValue = config.getJSONArray(VALUE);
                int n2 = configValue.length();
                for (int keyMappingIndex = 0; keyMappingIndex < n2; ++keyMappingIndex) {
                    JSONObject keyMapping = configValue.getJSONObject(keyMappingIndex);
                    String implicitKey = keyMapping.getString(KEY);
                    if (!Intrinsics.areEqual((Object)implicitKey, (Object)key)) continue;
                    JSONArray manualKeyArray = keyMapping.getJSONArray(VALUE);
                    ArrayList<String> manualKeys = new ArrayList<String>();
                    int n3 = manualKeyArray.length();
                    for (int manualKeyIndex = 0; manualKeyIndex < n3; ++manualKeyIndex) {
                        JSONObject manualKeyJSONObject = manualKeyArray.getJSONObject(manualKeyIndex);
                        String manualKey = manualKeyJSONObject.getString(VALUE);
                        manualKeys.add(manualKey);
                    }
                    resultList = new ArrayList();
                    resultList.addAll(manualKeys);
                    return resultList;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final ArrayList<Pair<String, List<String>>> parseDedupeParameters(JSONObject originalJSON, boolean getTestValues) {
        try {
            ArrayList<Pair> dedupeParameters = null;
            JSONObject jSONObject = originalJSON;
            Object object = jSONObject != null ? jSONObject.getJSONArray(DEDUPE_KEY) : null;
            if (object == null) {
                return null;
            }
            JSONArray dedupeConfigs = object;
            int n = dedupeConfigs.length();
            for (int index = 0; index < n; ++index) {
                JSONObject config = dedupeConfigs.getJSONObject(index);
                String configKey = config.getString(KEY);
                if (Intrinsics.areEqual((Object)configKey, (Object)PROD_DEDUPE_KEY) && getTestValues || Intrinsics.areEqual((Object)configKey, (Object)TEST_DEDUPE_KEY) && !getTestValues) continue;
                JSONArray configValue = config.getJSONArray(VALUE);
                int n2 = configValue.length();
                for (int keyMappingIndex = 0; keyMappingIndex < n2; ++keyMappingIndex) {
                    JSONObject keyMapping = configValue.getJSONObject(keyMappingIndex);
                    String implicitKey = keyMapping.getString(KEY);
                    if (Intrinsics.areEqual((Object)implicitKey, (Object)"_valueToSum") || Intrinsics.areEqual((Object)implicitKey, (Object)"fb_currency")) continue;
                    JSONArray manualKeyArray = keyMapping.getJSONArray(VALUE);
                    ArrayList<String> manualKeys = new ArrayList<String>();
                    int n3 = manualKeyArray.length();
                    for (int manualKeyIndex = 0; manualKeyIndex < n3; ++manualKeyIndex) {
                        JSONObject manualKeyJSONObject = manualKeyArray.getJSONObject(manualKeyIndex);
                        String manualKey = manualKeyJSONObject.getString(VALUE);
                        manualKeys.add(manualKey);
                    }
                    if (dedupeParameters == null) {
                        dedupeParameters = new ArrayList<Pair>();
                    }
                    dedupeParameters.add(new Pair((Object)implicitKey, manualKeys));
                }
            }
            return dedupeParameters;
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ ArrayList parseDedupeParameters$default(FetchedAppSettingsManager fetchedAppSettingsManager, JSONObject jSONObject, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fetchedAppSettingsManager.parseDedupeParameters(jSONObject, bl);
    }

    private final Map<String, Boolean> parseMigratedAutoLogValues(JSONObject settingsJSON) {
        if (settingsJSON == null) {
            return null;
        }
        Map values = new HashMap();
        if (!settingsJSON.isNull(AUTO_LOG_APP_EVENTS_DEFAULT_FIELD)) {
            try {
                values.put(AUTO_LOG_APP_EVENTS_DEFAULT_FIELD, settingsJSON.getBoolean(AUTO_LOG_APP_EVENTS_DEFAULT_FIELD));
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
        }
        if (!settingsJSON.isNull(AUTO_LOG_APP_EVENT_ENABLED_FIELD)) {
            try {
                values.put(AUTO_LOG_APP_EVENT_ENABLED_FIELD, settingsJSON.getBoolean(AUTO_LOG_APP_EVENT_ENABLED_FIELD));
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
        }
        return values.isEmpty() ? null : values;
    }

    private static final void loadAppSettingsAsync$lambda$0(Context $context, String $settingsKey, String $applicationId) {
        JSONObject resultJSON;
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$settingsKey, (String)"$settingsKey");
        Intrinsics.checkNotNullParameter((Object)$applicationId, (String)"$applicationId");
        SharedPreferences sharedPrefs = $context.getSharedPreferences(APP_SETTINGS_PREFS_STORE, 0);
        String settingsJSONString = sharedPrefs.getString($settingsKey, null);
        FetchedAppSettings appSettings = null;
        if (!Utility.isNullOrEmpty(settingsJSONString)) {
            if (settingsJSONString == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            JSONObject settingsJSON = null;
            try {
                settingsJSON = new JSONObject(settingsJSONString);
            }
            catch (JSONException je) {
                Utility.logd("FacebookSDK", (Exception)((Object)je));
            }
            if (settingsJSON != null) {
                appSettings = INSTANCE.parseAppSettingsFromJSON$facebook_core_release($applicationId, settingsJSON);
            }
        }
        if ((resultJSON = INSTANCE.getAppSettingsQueryResponse($applicationId)) != null) {
            INSTANCE.parseAppSettingsFromJSON$facebook_core_release($applicationId, resultJSON);
            sharedPrefs.edit().putString($settingsKey, resultJSON.toString()).apply();
        }
        if (appSettings != null) {
            String updateMessage = appSettings.getSdkUpdateMessage();
            if (!printedSDKUpdatedMessage && updateMessage != null && updateMessage.length() > 0) {
                printedSDKUpdatedMessage = true;
                Log.w((String)TAG, (String)updateMessage);
            }
        }
        FetchedAppGateKeepersManager.queryAppGateKeepers($applicationId, true);
        AutomaticAnalyticsLogger.logActivateAppEvent();
        loadingState.set(fetchedAppSettings.containsKey($applicationId) ? FetchAppSettingState.SUCCESS : FetchAppSettingState.ERROR);
        INSTANCE.pollCallbacks();
    }

    private static final void pollCallbacks$lambda$1(FetchedAppSettingsCallback $callback) {
        $callback.onError();
    }

    private static final void pollCallbacks$lambda$2(FetchedAppSettingsCallback $callback, FetchedAppSettings $appSettings) {
        $callback.onSuccess($appSettings);
    }

    static {
        Object[] objectArray = new String[]{APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, APP_SETTING_NUX_CONTENT, APP_SETTING_NUX_ENABLED, APP_SETTING_DIALOG_CONFIGS, APP_SETTING_ANDROID_SDK_ERROR_CATEGORIES, APP_SETTING_APP_EVENTS_SESSION_TIMEOUT, APP_SETTING_APP_EVENTS_FEATURE_BITMASK, APP_SETTING_APP_EVENTS_EVENT_BINDINGS, APP_SETTING_SMART_LOGIN_OPTIONS, SMART_LOGIN_BOOKMARK_ICON_URL, SMART_LOGIN_MENU_ICON_URL, APP_SETTING_RESTRICTIVE_EVENT_FILTER_FIELD, APP_SETTING_APP_EVENTS_AAM_RULE, SUGGESTED_EVENTS_SETTING, PROTECTED_MODE_RULES, AUTO_LOG_APP_EVENTS_DEFAULT_FIELD, AUTO_LOG_APP_EVENT_ENABLED_FIELD, "app_events_config.os_version(" + Build.VERSION.RELEASE + ')'};
        APP_SETTING_FIELDS = CollectionsKt.listOf((Object[])objectArray);
        fetchedAppSettings = new ConcurrentHashMap();
        loadingState = new AtomicReference<FetchAppSettingState>(FetchAppSettingState.NOT_LOADED);
        fetchedAppSettingsCallbacks = new ConcurrentLinkedQueue();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager$FetchAppSettingState;", "", "(Ljava/lang/String;I)V", "NOT_LOADED", "LOADING", "SUCCESS", "ERROR", "facebook-core_release"})
    public static final class FetchAppSettingState
    extends Enum<FetchAppSettingState> {
        public static final /* enum */ FetchAppSettingState NOT_LOADED = new FetchAppSettingState();
        public static final /* enum */ FetchAppSettingState LOADING = new FetchAppSettingState();
        public static final /* enum */ FetchAppSettingState SUCCESS = new FetchAppSettingState();
        public static final /* enum */ FetchAppSettingState ERROR = new FetchAppSettingState();
        private static final /* synthetic */ FetchAppSettingState[] $VALUES;

        public static FetchAppSettingState[] values() {
            return (FetchAppSettingState[])$VALUES.clone();
        }

        public static FetchAppSettingState valueOf(String value) {
            return Enum.valueOf(FetchAppSettingState.class, value);
        }

        static {
            $VALUES = fetchAppSettingStateArray = new FetchAppSettingState[]{FetchAppSettingState.NOT_LOADED, FetchAppSettingState.LOADING, FetchAppSettingState.SUCCESS, FetchAppSettingState.ERROR};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/FetchedAppSettingsManager$FetchedAppSettingsCallback;", "", "onError", "", "onSuccess", "fetchedAppSettings", "Lcom/facebook/internal/FetchedAppSettings;", "facebook-core_release"})
    public static interface FetchedAppSettingsCallback {
        public void onSuccess(@Nullable FetchedAppSettings var1);

        public void onError();
    }
}

