/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.anrreport.ANRHandler;
import com.facebook.internal.instrument.crashreport.CrashHandler;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.instrument.errorreport.ErrorReportHandler;
import com.facebook.internal.instrument.threadcheck.ThreadCheckHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/facebook/internal/instrument/InstrumentManager;", "", "()V", "start", "", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstrumentManager {
    @NotNull
    public static final InstrumentManager INSTANCE = new InstrumentManager();

    private InstrumentManager() {
    }

    @JvmStatic
    public static final void start() {
        if (!FacebookSdk.getAutoLogAppEventsEnabled()) {
            return;
        }
        FeatureManager.checkFeature(FeatureManager.Feature.CrashReport, InstrumentManager::start$lambda$0);
        FeatureManager.checkFeature(FeatureManager.Feature.ErrorReport, InstrumentManager::start$lambda$1);
        FeatureManager.checkFeature(FeatureManager.Feature.AnrReport, InstrumentManager::start$lambda$2);
    }

    private static final void start$lambda$0(boolean enabled) {
        if (enabled) {
            CrashHandler.Companion.enable();
            if (FeatureManager.isEnabled(FeatureManager.Feature.CrashShield)) {
                ExceptionAnalyzer.enable();
                CrashShieldHandler.enable();
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.ThreadCheck)) {
                ThreadCheckHandler.enable();
            }
        }
    }

    private static final void start$lambda$1(boolean enabled) {
        if (enabled) {
            ErrorReportHandler.enable();
        }
    }

    private static final void start$lambda$2(boolean enabled) {
        if (enabled) {
            ANRHandler.enable();
        }
    }
}

