/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.anrreport;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.anrreport.ANRDetector;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/internal/instrument/anrreport/ANRHandler;", "", "()V", "MAX_ANR_REPORT_NUM", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enable", "", "sendANRReports", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nANRHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ANRHandler.kt\ncom/facebook/internal/instrument/anrreport/ANRHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n11335#2:78\n11670#2,3:79\n766#3:82\n857#3,2:83\n1855#3,2:85\n1855#3,2:87\n*S KotlinDebug\n*F\n+ 1 ANRHandler.kt\ncom/facebook/internal/instrument/anrreport/ANRHandler\n*L\n58#1:78\n58#1:79,3\n59#1:82\n59#1:83,2\n63#1:85,2\n69#1:87,2\n*E\n"})
public final class ANRHandler {
    @NotNull
    public static final ANRHandler INSTANCE = new ANRHandler();
    private static final int MAX_ANR_REPORT_NUM = 5;
    @NotNull
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    private ANRHandler() {
    }

    @JvmStatic
    public static final synchronized void enable() {
        if (CrashShieldHandler.isObjectCrashing(ANRHandler.class)) {
            return;
        }
        try {
            if (enabled.getAndSet(true)) {
                return;
            }
            if (FacebookSdk.getAutoLogAppEventsEnabled()) {
                INSTANCE.sendANRReports();
            }
            ANRDetector.start();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ANRHandler.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @VisibleForTesting
    public static final void sendANRReports() {
        if (CrashShieldHandler.isObjectCrashing(ANRHandler.class)) {
            return;
        }
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            File[] reports;
            if (Utility.isDataProcessingRestricted()) {
                return;
            }
            File[] $this$map$iv = reports = InstrumentUtility.listAnrReportFiles();
            boolean $i$f$map = false;
            File[] fileArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(InstrumentData.Builder.load((File)it));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InstrumentData it = (InstrumentData)element$iv$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validReports = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), ANRHandler::sendANRReports$lambda$2);
            JSONArray anrLogs = new JSONArray();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)Math.min(validReports.size(), 5));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                anrLogs.put(validReports.get(it));
            }
            InstrumentUtility.sendReports("anr_reports", anrLogs, arg_0 -> ANRHandler.sendANRReports$lambda$5(validReports, arg_0));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ANRHandler.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int sendANRReports$lambda$2(InstrumentData instrumentData, InstrumentData instrumentData2) {
        if (CrashShieldHandler.isObjectCrashing(ANRHandler.class)) {
            return 0;
        }
        try {
            InstrumentData o1;
            void o2;
            Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
            return o1.compareTo((InstrumentData)o2);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ANRHandler.class);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void sendANRReports$lambda$5(List list, GraphResponse graphResponse) {
        if (CrashShieldHandler.isObjectCrashing(ANRHandler.class)) {
            return;
        }
        try {
            void response;
            List $validReports;
            Intrinsics.checkNotNullParameter((Object)$validReports, (String)"$validReports");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                if (response.getError() == null) {
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jSONObject = response.getJsonObject();
                    boolean bl = jSONObject2 != null ? jSONObject2.getBoolean("success") : false;
                    if (bl) {
                        Iterable $this$forEach$iv = $validReports;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            InstrumentData it = (InstrumentData)element$iv;
                            boolean bl2 = false;
                            it.clear();
                        }
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ANRHandler.class);
            return;
        }
    }
}

