/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashreport;

import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/instrument/crashreport/CrashHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "previousHandler", "(Ljava/lang/Thread$UncaughtExceptionHandler;)V", "uncaughtException", "", "t", "Ljava/lang/Thread;", "e", "", "Companion", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CrashHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Thread.UncaughtExceptionHandler previousHandler;
    private static final String TAG = CrashHandler.class.getCanonicalName();
    private static final int MAX_CRASH_REPORT_NUM = 5;
    @Nullable
    private static CrashHandler instance;

    private CrashHandler(Thread.UncaughtExceptionHandler previousHandler) {
        this.previousHandler = previousHandler;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (InstrumentUtility.isSDKRelatedException(e)) {
                ExceptionAnalyzer.execute(e);
                InstrumentData.Builder.build(e, InstrumentData.Type.CrashReport).save();
            }
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.previousHandler;
            if (uncaughtExceptionHandler == null) break block1;
            uncaughtExceptionHandler.uncaughtException(t, e);
        }
    }

    @JvmStatic
    public static final synchronized void enable() {
        Companion.enable();
    }

    public /* synthetic */ CrashHandler(Thread.UncaughtExceptionHandler previousHandler, DefaultConstructorMarker $constructor_marker) {
        this(previousHandler);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/instrument/crashreport/CrashHandler$Companion;", "", "()V", "MAX_CRASH_REPORT_NUM", "", "TAG", "", "kotlin.jvm.PlatformType", "instance", "Lcom/facebook/internal/instrument/crashreport/CrashHandler;", "enable", "", "sendExceptionReports", "facebook-core_release"})
    @SourceDebugExtension(value={"SMAP\nCrashHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashHandler.kt\ncom/facebook/internal/instrument/crashreport/CrashHandler$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n11335#2:89\n11670#2,3:90\n766#3:93\n857#3,2:94\n1855#3,2:96\n1855#3,2:98\n*S KotlinDebug\n*F\n+ 1 CrashHandler.kt\ncom/facebook/internal/instrument/crashreport/CrashHandler$Companion\n*L\n66#1:89\n66#1:90,3\n67#1:93\n67#1:94,2\n72#1:96,2\n79#1:98,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void enable() {
            if (FacebookSdk.getAutoLogAppEventsEnabled()) {
                this.sendExceptionReports();
            }
            if (instance != null) {
                Log.w((String)TAG, (String)"Already enabled!");
                return;
            }
            Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
            instance = new CrashHandler(oldHandler, null);
            Thread.setDefaultUncaughtExceptionHandler(instance);
        }

        /*
         * WARNING - void declaration
         */
        private final void sendExceptionReports() {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            File[] reports;
            if (Utility.isDataProcessingRestricted()) {
                return;
            }
            File[] $this$map$iv = reports = InstrumentUtility.listExceptionReportFiles();
            boolean $i$f$map = false;
            File[] fileArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(InstrumentData.Builder.load((File)it));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InstrumentData it = (InstrumentData)element$iv$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validReports = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), Companion::sendExceptionReports$lambda$2);
            JSONArray crashLogs = new JSONArray();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)Math.min(validReports.size(), 5));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                crashLogs.put(validReports.get(it));
            }
            InstrumentUtility.sendReports("crash_reports", crashLogs, arg_0 -> Companion.sendExceptionReports$lambda$5(validReports, arg_0));
        }

        private static final int sendExceptionReports$lambda$2(InstrumentData o1, InstrumentData o2) {
            Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
            return o1.compareTo(o2);
        }

        private static final void sendExceptionReports$lambda$5(List $validReports, GraphResponse response) {
            Intrinsics.checkNotNullParameter((Object)$validReports, (String)"$validReports");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                if (response.getError() == null) {
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jSONObject = response.getJsonObject();
                    boolean bl = jSONObject2 != null ? jSONObject2.getBoolean("success") : false;
                    if (bl) {
                        Iterable $this$forEach$iv = $validReports;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            InstrumentData it = (InstrumentData)element$iv;
                            boolean bl2 = false;
                            it.clear();
                        }
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

