/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.net.Uri;
import com.facebook.FacebookCallback;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.List;

@AutoHandleExceptions
public class GamingGroupIntegration
extends FacebookDialogBase<Void, Result> {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GamingGroupIntegration.toRequestCode();
    private static final String ERROR_KEY = "error";

    public GamingGroupIntegration(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public GamingGroupIntegration(Fragment fragment) {
        super(new FragmentWrapper(fragment), DEFAULT_REQUEST_CODE);
    }

    public GamingGroupIntegration(androidx.fragment.app.Fragment fragment) {
        super(new FragmentWrapper(fragment), DEFAULT_REQUEST_CODE);
    }

    public void show() {
        this.showImpl();
    }

    public void show(Void content) {
        this.showImpl();
    }

    protected void showImpl() {
        String uri = "https://fb.gg/me/community/" + FacebookSdk.getApplicationId();
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        this.startActivityForResult(intent, this.getRequestCode());
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, final FacebookCallback callback) {
        callbackManager.registerCallback(this.getRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                if (data != null && data.hasExtra(GamingGroupIntegration.ERROR_KEY)) {
                    FacebookRequestError error = (FacebookRequestError)data.getParcelableExtra(GamingGroupIntegration.ERROR_KEY);
                    callback.onError(error.getException());
                    return true;
                }
                callback.onSuccess((Object)new Result());
                return true;
            }
        });
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        return null;
    }

    protected AppCall createBaseAppCall() {
        return null;
    }

    public static class Result {
    }
}

