/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.facebook.AccessToken;
import com.facebook.GraphRequest;
import com.facebook.gamingservices.OpenGamingMediaDialog;
import java.io.File;
import java.io.FileNotFoundException;

public class GamingImageUploader {
    private static final String photoUploadEdge = "me/photos";
    private Context context;

    public GamingImageUploader(Context context) {
        this.context = context;
    }

    public void uploadToMediaLibrary(String caption, Bitmap imageBitmap, boolean shouldLaunchMediaDialog) {
        this.uploadToMediaLibrary(caption, imageBitmap, shouldLaunchMediaDialog, null);
    }

    public void uploadToMediaLibrary(String caption, Bitmap imageBitmap, boolean shouldLaunchMediaDialog, GraphRequest.Callback callback) {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        Object openMediaCallback = callback;
        if (shouldLaunchMediaDialog) {
            openMediaCallback = new OpenGamingMediaDialog(this.context, callback);
        }
        GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)photoUploadEdge, (Bitmap)imageBitmap, (String)caption, null, (GraphRequest.Callback)openMediaCallback).executeAsync();
    }

    public void uploadToMediaLibrary(String caption, File imageFile, boolean shouldLaunchMediaDialog) throws FileNotFoundException {
        this.uploadToMediaLibrary(caption, imageFile, shouldLaunchMediaDialog, null);
    }

    public void uploadToMediaLibrary(String caption, File imageFile, boolean shouldLaunchMediaDialog, GraphRequest.Callback callback) throws FileNotFoundException {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        Object openMediaCallback = callback;
        if (shouldLaunchMediaDialog) {
            openMediaCallback = new OpenGamingMediaDialog(this.context, callback);
        }
        GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)photoUploadEdge, (File)imageFile, (String)caption, null, (GraphRequest.Callback)openMediaCallback).executeAsync();
    }

    public void uploadToMediaLibrary(String caption, Uri imageUri, boolean shouldLaunchMediaDialog) throws FileNotFoundException {
        this.uploadToMediaLibrary(caption, imageUri, shouldLaunchMediaDialog, null);
    }

    public void uploadToMediaLibrary(String caption, Uri imageUri, boolean shouldLaunchMediaDialog, GraphRequest.Callback callback) throws FileNotFoundException {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        Object requestCallback = callback;
        if (shouldLaunchMediaDialog) {
            requestCallback = new OpenGamingMediaDialog(this.context, callback);
        }
        GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)photoUploadEdge, (Uri)imageUri, (String)caption, null, (GraphRequest.Callback)requestCallback).executeAsync();
    }
}

