/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.cloudgaming;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.facebook.FacebookRequestError;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.cloudgaming.DaemonReceiver;
import com.facebook.gamingservices.cloudgaming.internal.SDKLogger;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.json.JSONException;
import org.json.JSONObject;

public class DaemonRequest {
    private Context mContext;
    private JSONObject mParameters;
    private Callback mCallback;
    private ConcurrentHashMap<String, CompletableFuture<GraphResponse>> mRequestStore;
    private SDKLogger mLogger;

    DaemonRequest(Context context, JSONObject parameters, Callback callback) {
        this.mContext = context;
        this.mParameters = parameters;
        this.mCallback = callback;
        this.mRequestStore = DaemonReceiver.getInstance(context).getRequestStore();
        this.mLogger = SDKLogger.getInstance(context);
    }

    private void executeAsync() throws ExecutionException, InterruptedException {
        this.createRequest().thenAccept((Consumer)new Consumer<GraphResponse>(){

            @Override
            public void accept(GraphResponse response) {
                if (DaemonRequest.this.mCallback != null) {
                    DaemonRequest.this.mCallback.onCompleted(response);
                }
            }
        });
    }

    private GraphResponse executeAndWait() throws ExecutionException, InterruptedException {
        return this.createRequest().get();
    }

    private GraphResponse executeAndWait(int timeout) throws ExecutionException, InterruptedException, TimeoutException {
        return this.createRequest().get(timeout, TimeUnit.SECONDS);
    }

    private CompletableFuture<GraphResponse> createRequest() {
        CompletableFuture<GraphResponse> response = CompletableFuture.supplyAsync(new Supplier<GraphResponse>(){

            @Override
            public GraphResponse get() {
                String uniqueID = UUID.randomUUID().toString();
                try {
                    DaemonRequest.this.mParameters.put("requestID", (Object)uniqueID);
                    Intent intent = new Intent();
                    String functionType = DaemonRequest.this.mParameters.getString("type");
                    DaemonRequest.this.mLogger.logPreparingRequest(functionType, uniqueID, DaemonRequest.this.mParameters);
                    if (!functionType.equals(SDKMessageEnum.GET_ACCESS_TOKEN.toString()) && !functionType.equals(SDKMessageEnum.IS_ENV_READY.toString())) {
                        SharedPreferences sharedPreferences = DaemonRequest.this.mContext.getSharedPreferences("com.facebook.gamingservices.cloudgaming:preferences", 0);
                        String daemonPackageName = sharedPreferences.getString("daemonPackageName", null);
                        if (daemonPackageName == null) {
                            FacebookRequestError error = new FacebookRequestError(-1, "DAEMON_REQUEST_EXECUTE_ASYNC_FAILED", "Unable to correctly create the request with a secure connection");
                            return DaemonReceiver.createErrorResponse(error, uniqueID);
                        }
                        intent.setPackage(daemonPackageName);
                    }
                    intent.setAction("com.facebook.gamingservices.DAEMON_REQUEST");
                    Iterator iter = DaemonRequest.this.mParameters.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        String value = DaemonRequest.this.mParameters.getString(key);
                        intent.putExtra(key, value);
                    }
                    CompletableFuture future = new CompletableFuture();
                    DaemonRequest.this.mRequestStore.put(uniqueID, future);
                    DaemonRequest.this.mContext.sendBroadcast(intent);
                    DaemonRequest.this.mLogger.logSentRequest(functionType, uniqueID, DaemonRequest.this.mParameters);
                    return (GraphResponse)future.get();
                }
                catch (InterruptedException | ExecutionException | JSONException e) {
                    FacebookRequestError error = new FacebookRequestError(-1, "DAEMON_REQUEST_EXECUTE_ASYNC_FAILED", "Unable to correctly create the request or obtain response");
                    return DaemonReceiver.createErrorResponse(error, uniqueID);
                }
            }
        });
        return response;
    }

    public static void executeAsync(Context context, @Nullable JSONObject parameters, Callback callback, SDKMessageEnum type) {
        block2: {
            try {
                JSONObject updatedParameters = parameters == null ? new JSONObject().put("type", (Object)type.toString()) : parameters.put("type", (Object)type.toString());
                DaemonRequest request = new DaemonRequest(context, updatedParameters, callback);
                request.executeAsync();
            }
            catch (InterruptedException | ExecutionException | JSONException e) {
                if (callback == null) break block2;
                FacebookRequestError error = new FacebookRequestError(-1, "DAEMON_REQUEST_EXECUTE_ASYNC_FAILED", "Unable to correctly create the request or obtain response");
                callback.onCompleted(DaemonReceiver.createErrorResponse(error, null));
            }
        }
    }

    public static GraphResponse executeAndWait(Context context, @Nullable JSONObject parameters, SDKMessageEnum type) {
        try {
            JSONObject updatedParameters = parameters == null ? new JSONObject().put("type", (Object)type.toString()) : parameters.put("type", (Object)type.toString());
            DaemonRequest request = new DaemonRequest(context, updatedParameters, null);
            return request.executeAndWait();
        }
        catch (InterruptedException | ExecutionException | JSONException e) {
            FacebookRequestError error = new FacebookRequestError(-1, "DAEMON_REQUEST_EXECUTE_ASYNC_FAILED", "Unable to correctly create the request or obtain response");
            return DaemonReceiver.createErrorResponse(error, null);
        }
    }

    public static GraphResponse executeAndWait(Context context, @Nullable JSONObject parameters, SDKMessageEnum type, int timeout) {
        try {
            JSONObject updatedParameters = parameters == null ? new JSONObject().put("type", (Object)type.toString()) : parameters.put("type", (Object)type.toString());
            DaemonRequest request = new DaemonRequest(context, updatedParameters, null);
            return request.executeAndWait(timeout);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | JSONException e) {
            FacebookRequestError error = new FacebookRequestError(-1, "DAEMON_REQUEST_EXECUTE_ASYNC_FAILED", "Unable to correctly create the request or obtain response");
            return DaemonReceiver.createErrorResponse(error, null);
        }
    }

    public static void executeAsync(Context context, @Nullable JSONObject parameters, Callback callback, String type) {
        block2: {
            try {
                JSONObject updatedParameters = parameters == null ? new JSONObject().put("type", (Object)type) : parameters.put("type", (Object)type);
                DaemonRequest request = new DaemonRequest(context, updatedParameters, callback);
                request.executeAsync();
            }
            catch (InterruptedException | ExecutionException | JSONException e) {
                if (callback == null) break block2;
                FacebookRequestError error = new FacebookRequestError(-1, "DAEMON_REQUEST_EXECUTE_ASYNC_FAILED", "Unable to correctly create the request or obtain response");
                callback.onCompleted(DaemonReceiver.createErrorResponse(error, null));
            }
        }
    }

    public static interface Callback {
        public void onCompleted(GraphResponse var1);
    }
}

