/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.appwakeup;

import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppWakeupMetrics
extends SystemMetrics<AppWakeupMetrics> {
    public SimpleArrayMap<String, WakeupDetails> appWakeups = new SimpleArrayMap();

    @Override
    public AppWakeupMetrics set(AppWakeupMetrics metrics) {
        this.appWakeups.clear();
        this.appWakeups.putAll(metrics.appWakeups);
        return this;
    }

    @Override
    public AppWakeupMetrics sum(@Nullable AppWakeupMetrics b, @Nullable AppWakeupMetrics output) {
        if (output == null) {
            output = new AppWakeupMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            String tag;
            int i;
            output.appWakeups.clear();
            for (i = 0; i < this.appWakeups.size(); ++i) {
                tag = (String)this.appWakeups.keyAt(i);
                output.appWakeups.put((Object)tag, (Object)new WakeupDetails(((WakeupDetails)this.appWakeups.valueAt((int)i)).reason));
                ((WakeupDetails)this.appWakeups.valueAt(i)).sum((WakeupDetails)b.appWakeups.get((Object)tag), (WakeupDetails)output.appWakeups.get((Object)tag));
            }
            for (i = 0; i < b.appWakeups.size(); ++i) {
                tag = (String)b.appWakeups.keyAt(i);
                if (output.appWakeups.containsKey((Object)tag)) continue;
                output.appWakeups.put((Object)tag, b.appWakeups.valueAt(i));
            }
        }
        return output;
    }

    @Override
    public AppWakeupMetrics diff(@Nullable AppWakeupMetrics b, @Nullable AppWakeupMetrics output) {
        if (output == null) {
            output = new AppWakeupMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.appWakeups.clear();
            for (int i = 0; i < this.appWakeups.size(); ++i) {
                String tag = (String)this.appWakeups.keyAt(i);
                output.appWakeups.put((Object)tag, (Object)new WakeupDetails(((WakeupDetails)this.appWakeups.valueAt((int)i)).reason));
                ((WakeupDetails)this.appWakeups.valueAt(i)).diff((WakeupDetails)b.appWakeups.get((Object)tag), (WakeupDetails)output.appWakeups.get((Object)tag));
            }
        }
        return output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppWakeupMetrics that = (AppWakeupMetrics)o;
        return Utilities.simpleArrayMapEquals(this.appWakeups, that.appWakeups);
    }

    public int hashCode() {
        return this.appWakeups != null ? this.appWakeups.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.appWakeups.size(); ++i) {
            sb.append((String)this.appWakeups.keyAt(i)).append(": ").append(this.appWakeups.valueAt(i)).append(", ");
        }
        return sb.toString();
    }

    public JSONArray toJSON() throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < this.appWakeups.size(); ++i) {
            JSONObject obj = new JSONObject();
            WakeupDetails details = (WakeupDetails)this.appWakeups.valueAt(i);
            obj.put("key", this.appWakeups.keyAt(i));
            obj.put("type", (Object)details.reason.toString());
            obj.put("count", details.count);
            obj.put("time_ms", details.wakeupTimeMs);
            jsonArray.put((Object)obj);
        }
        return jsonArray;
    }

    public static class WakeupDetails {
        public WakeupReason reason;
        public long count;
        public long wakeupTimeMs;

        public WakeupDetails() {
            this.count = 0L;
            this.wakeupTimeMs = 0L;
        }

        public WakeupDetails(WakeupReason reason) {
            this(reason, 0L, 0L);
        }

        public WakeupDetails(WakeupReason reason, long count, long wakeupTimeMs) {
            this.reason = reason;
            this.count = count;
            this.wakeupTimeMs = wakeupTimeMs;
        }

        public WakeupDetails set(WakeupDetails details) {
            this.reason = details.reason;
            this.count = details.count;
            this.wakeupTimeMs = details.wakeupTimeMs;
            return this;
        }

        public WakeupDetails sum(@Nullable WakeupDetails b, WakeupDetails output) {
            if (b == null) {
                return output.set(this);
            }
            if (b.reason != this.reason) {
                SystemMetricsLogger.wtf("AppWakeupMetrics", "Sum only allowed for similar wakeups: " + this.toString() + ", " + b.toString());
            }
            output.reason = this.reason;
            output.count = this.count + b.count;
            output.wakeupTimeMs = this.wakeupTimeMs + b.wakeupTimeMs;
            return this;
        }

        public WakeupDetails diff(@Nullable WakeupDetails b, WakeupDetails output) {
            if (b == null) {
                return output.set(this);
            }
            if (b.reason != this.reason) {
                SystemMetricsLogger.wtf("AppWakeupMetrics", "Diff only allowed for similar kind of wakeups: " + this.toString() + ", " + b.toString());
            }
            output.reason = this.reason;
            output.count = this.count - b.count;
            output.wakeupTimeMs = this.wakeupTimeMs - b.wakeupTimeMs;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WakeupDetails that = (WakeupDetails)o;
            if (this.count != that.count) {
                return false;
            }
            if (this.wakeupTimeMs != that.wakeupTimeMs) {
                return false;
            }
            return this.reason == that.reason;
        }

        public int hashCode() {
            int result = this.reason != null ? this.reason.hashCode() : 0;
            result = 31 * result + (int)(this.count ^ this.count >>> 32);
            result = 31 * result + (int)(this.wakeupTimeMs ^ this.wakeupTimeMs >>> 32);
            return result;
        }

        public String toString() {
            return "{reason=" + (Object)((Object)this.reason) + ", count=" + this.count + ", wakeupTimeMs=" + this.wakeupTimeMs + "}";
        }
    }

    public static enum WakeupReason {
        JOB_SCHEDULER,
        GCM,
        ALARM;

    }
}

