/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.appwakeup;

import android.os.SystemClock;
import com.facebook.battery.metrics.appwakeup.AppWakeupMetrics;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import com.facebook.infer.annotation.ThreadSafe;

@ThreadSafe
public class AppWakeupMetricsCollector
extends SystemMetricsCollector<AppWakeupMetrics> {
    private static final String TAG = "AppWakeupMetricsCollector";
    private final AppWakeupMetrics mMetrics = new AppWakeupMetrics();
    private final AppWakeupMetrics mRunningWakeups = new AppWakeupMetrics();

    @Override
    @ThreadSafe(enableChecks=false)
    public synchronized boolean getSnapshot(AppWakeupMetrics snapshot) {
        Utilities.checkNotNull(snapshot, "Null value passed to getSnapshot!");
        snapshot.appWakeups.clear();
        for (int i = 0; i < this.mMetrics.appWakeups.size(); ++i) {
            AppWakeupMetrics.WakeupDetails details = new AppWakeupMetrics.WakeupDetails();
            details.set((AppWakeupMetrics.WakeupDetails)this.mMetrics.appWakeups.valueAt(i));
            snapshot.appWakeups.put(this.mMetrics.appWakeups.keyAt(i), (Object)details);
        }
        return true;
    }

    @Override
    public AppWakeupMetrics createMetrics() {
        return new AppWakeupMetrics();
    }

    public synchronized void recordWakeupStart(AppWakeupMetrics.WakeupReason reason, String id) {
        if (this.mRunningWakeups.appWakeups.containsKey((Object)id)) {
            SystemMetricsLogger.wtf(TAG, "Wakeup started again without ending for " + id + " (" + (Object)((Object)reason) + ")");
            return;
        }
        this.mRunningWakeups.appWakeups.put((Object)id, (Object)new AppWakeupMetrics.WakeupDetails(reason, 1L, SystemClock.elapsedRealtime()));
    }

    public synchronized void recordWakeupEnd(String id) {
        if (!this.mRunningWakeups.appWakeups.containsKey((Object)id)) {
            return;
        }
        AppWakeupMetrics.WakeupDetails details = (AppWakeupMetrics.WakeupDetails)this.mRunningWakeups.appWakeups.get((Object)id);
        details.wakeupTimeMs = SystemClock.elapsedRealtime() - details.wakeupTimeMs;
        if (!this.mMetrics.appWakeups.containsKey((Object)id)) {
            this.mMetrics.appWakeups.put((Object)id, (Object)new AppWakeupMetrics.WakeupDetails().set(details));
        } else {
            ((AppWakeupMetrics.WakeupDetails)this.mMetrics.appWakeups.get((Object)id)).sum(details, (AppWakeupMetrics.WakeupDetails)this.mMetrics.appWakeups.get((Object)id));
        }
        this.mRunningWakeups.appWakeups.remove((Object)id);
    }
}

