/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.composite;

import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.Utilities;

public class CompositeMetrics
extends SystemMetrics<CompositeMetrics> {
    private final SimpleArrayMap<Class<? extends SystemMetrics>, SystemMetrics> mMetricsMap = new SimpleArrayMap();
    private final SimpleArrayMap<Class<? extends SystemMetrics>, Boolean> mMetricsValid = new SimpleArrayMap();

    @Override
    public CompositeMetrics diff(@Nullable CompositeMetrics b, CompositeMetrics result) {
        if (result == null) {
            throw new IllegalArgumentException("CompositeMetrics doesn't support nullable results");
        }
        if (b == null) {
            result.set(this);
        } else {
            int size = this.mMetricsMap.size();
            for (int i = 0; i < size; ++i) {
                Object resultMetric;
                boolean valid;
                Class c = (Class)this.mMetricsMap.keyAt(i);
                boolean bl = valid = this.isValid(c) && b.isValid(c);
                if (valid && (resultMetric = result.getMetric(c)) != null) {
                    ((SystemMetrics)this.getMetric(c)).diff(b.getMetric(c), resultMetric);
                }
                result.setIsValid(c, valid);
            }
        }
        return result;
    }

    @Override
    public CompositeMetrics sum(@Nullable CompositeMetrics b, CompositeMetrics result) {
        if (result == null) {
            throw new IllegalArgumentException("CompositeMetrics doesn't support nullable results");
        }
        if (b == null) {
            result.set(this);
        } else {
            int size = this.mMetricsMap.size();
            for (int i = 0; i < size; ++i) {
                Object resultMetric;
                boolean valid;
                Class c = (Class)this.mMetricsMap.keyAt(i);
                boolean bl = valid = this.isValid(c) && b.isValid(c);
                if (valid && (resultMetric = result.getMetric(c)) != null) {
                    ((SystemMetrics)this.getMetric(c)).sum(b.getMetric(c), resultMetric);
                }
                result.setIsValid(c, valid);
            }
        }
        return result;
    }

    @Override
    public CompositeMetrics set(CompositeMetrics input) {
        int size = this.mMetricsMap.size();
        for (int i = 0; i < size; ++i) {
            Class c = (Class)this.mMetricsMap.keyAt(i);
            Object metric = input.getMetric(c);
            if (metric != null) {
                ((SystemMetrics)this.getMetric(c)).set(metric);
                this.setIsValid(c, input.isValid(c));
                continue;
            }
            this.setIsValid(c, false);
        }
        return this;
    }

    public <T extends SystemMetrics<T>> CompositeMetrics putMetric(Class<T> metricsClass, T metric) {
        this.mMetricsMap.put(metricsClass, metric);
        this.mMetricsValid.put(metricsClass, (Object)Boolean.FALSE);
        return this;
    }

    public <T extends SystemMetrics<T>> T getMetric(Class<T> metricsClass) {
        return (T)((SystemMetrics)metricsClass.cast(this.mMetricsMap.get(metricsClass)));
    }

    public boolean isValid(Class c) {
        Boolean value = (Boolean)this.mMetricsValid.get((Object)c);
        return value != null && value != false;
    }

    public void setIsValid(Class c, boolean isValid) {
        this.mMetricsValid.put((Object)c, (Object)(isValid ? Boolean.TRUE : Boolean.FALSE));
    }

    public SimpleArrayMap<Class<? extends SystemMetrics>, SystemMetrics> getMetrics() {
        return this.mMetricsMap;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Composite Metrics{\n");
        int size = this.mMetricsMap.size();
        for (int i = 0; i < size; ++i) {
            b.append(this.mMetricsMap.valueAt(i)).append(this.isValid((Class)this.mMetricsMap.keyAt(i)) ? " [valid]" : " [invalid]").append('\n');
        }
        b.append("}");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeMetrics that = (CompositeMetrics)o;
        return Utilities.simpleArrayMapEquals(this.mMetricsValid, that.mMetricsValid) && Utilities.simpleArrayMapEquals(this.mMetricsMap, that.mMetricsMap);
    }

    public int hashCode() {
        int result = this.mMetricsMap.hashCode();
        result = 31 * result + this.mMetricsValid.hashCode();
        return result;
    }
}

