/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.cpu;

import android.os.StrictMode;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import com.facebook.battery.metrics.cpu.CpuMetrics;
import com.facebook.battery.metrics.cpu.Sysconf;
import com.facebook.infer.annotation.ThreadSafe;
import java.io.IOException;
import java.io.RandomAccessFile;

@ThreadSafe
public class CpuMetricsCollector
extends SystemMetricsCollector<CpuMetrics> {
    private static final String TAG = "CpuMetricsCollector";
    private static final String PROC_STAT_FILE_PATH = "/proc/self/stat";
    private static final int PROC_USER_TIME_FIELD = 13;
    private static final int PROC_SYSTEM_TIME_FIELD = 14;
    private static final int PROC_CHILD_USER_TIME_FIELD = 15;
    private static final int PROC_CHILD_SYSTEM_TIME_FIELD = 16;
    private final ThreadLocal<CpuMetrics> mLastSnapshot = new ThreadLocal();
    @VisibleForTesting
    protected static final long DEFAULT_CLOCK_TICKS_PER_SECOND = 100L;

    @Override
    @ThreadSafe(enableChecks=false)
    public boolean getSnapshot(CpuMetrics snapshot) {
        String[] fields;
        Utilities.checkNotNull(snapshot, "Null value passed to getSnapshot!");
        String procFileContents = this.readProcFile();
        String[] stringArray = fields = procFileContents != null ? procFileContents.split(" ", 18) : null;
        if (fields == null || fields.length < 17) {
            return false;
        }
        try {
            snapshot.userTimeS = CpuMetricsCollector.readFieldAsS(fields[13]);
            snapshot.systemTimeS = CpuMetricsCollector.readFieldAsS(fields[14]);
            snapshot.childUserTimeS = CpuMetricsCollector.readFieldAsS(fields[15]);
            snapshot.childSystemTimeS = CpuMetricsCollector.readFieldAsS(fields[16]);
        }
        catch (NumberFormatException nfe) {
            SystemMetricsLogger.wtf(TAG, "Unable to parse CPU time field", nfe);
            return false;
        }
        if (this.mLastSnapshot.get() == null) {
            this.mLastSnapshot.set(new CpuMetrics());
        }
        CpuMetrics lastSnapshot = this.mLastSnapshot.get();
        if (Double.compare(snapshot.userTimeS, lastSnapshot.userTimeS) < 0 || Double.compare(snapshot.systemTimeS, lastSnapshot.systemTimeS) < 0 || Double.compare(snapshot.childUserTimeS, lastSnapshot.childUserTimeS) < 0 || Double.compare(snapshot.childSystemTimeS, lastSnapshot.childSystemTimeS) < 0) {
            SystemMetricsLogger.wtf(TAG, "Cpu Time Decreased from " + lastSnapshot.toString() + " to " + snapshot.toString());
            return false;
        }
        lastSnapshot.set(snapshot);
        return true;
    }

    @Override
    public CpuMetrics createMetrics() {
        return new CpuMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    protected String readProcFile() {
        StrictMode.ThreadPolicy originalPolicy = StrictMode.allowThreadDiskReads();
        RandomAccessFile procFile = null;
        try {
            procFile = new RandomAccessFile(PROC_STAT_FILE_PATH, "r");
            String string = procFile.readLine();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (procFile != null) {
                try {
                    procFile.close();
                }
                catch (IOException iOException) {}
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalPolicy);
        }
    }

    private static double readFieldAsS(String field) throws NumberFormatException {
        return (double)Long.parseLong(field) * 1.0 / (double)CpuMetricsCollector.getClockTicksPerSecond();
    }

    static long getClockTicksPerSecond() {
        return Initializer.CLOCK_TICKS_PER_SECOND;
    }

    private static class Initializer {
        static final long CLOCK_TICKS_PER_SECOND = Sysconf.getScClkTck(100L);

        private Initializer() {
        }
    }
}

