/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.cpu;

import android.annotation.SuppressLint;
import android.os.Build;
import android.system.Os;
import android.system.OsConstants;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import java.lang.reflect.InvocationTargetException;

class Sysconf {
    private static final String TAG = "Sysconf";

    Sysconf() {
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static long getScClkTck(long fallback) {
        long result = fallback;
        if (Build.VERSION.SDK_INT >= 21) {
            result = Os.sysconf((int)OsConstants._SC_CLK_TCK);
        } else if (Build.VERSION.SDK_INT >= 14) {
            result = Sysconf.fromLibcore("_SC_CLK_TCK", fallback);
        }
        return result > 0L ? result : fallback;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static long getScNProcessorsConf(long fallback) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Os.sysconf((int)OsConstants._SC_NPROCESSORS_CONF);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            return Sysconf.fromLibcore("_SC_NPROCESSORS_CONF", fallback);
        }
        return fallback;
    }

    private static long fromLibcore(String field, long fallback) {
        try {
            Class<?> osConstantsClass = Class.forName("libcore.io.OsConstants");
            int scClkTck = osConstantsClass.getField(field).getInt(null);
            Class<?> libcoreClass = Class.forName("libcore.io.Libcore");
            Class<?> osClass = Class.forName("libcore.io.Os");
            Object osInstance = libcoreClass.getField("os").get(null);
            return (Long)osClass.getMethod("sysconf", Integer.TYPE).invoke(osInstance, scClkTck);
        }
        catch (NoSuchMethodException ex) {
            Sysconf.logReflectionException(ex);
        }
        catch (NoSuchFieldException ex) {
            Sysconf.logReflectionException(ex);
        }
        catch (IllegalAccessException ex) {
            Sysconf.logReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            Sysconf.logReflectionException(ex);
        }
        catch (ClassNotFoundException ex) {
            Sysconf.logReflectionException(ex);
        }
        return fallback;
    }

    private static void logReflectionException(Exception ex) {
        SystemMetricsLogger.wtf(TAG, "Unable to read _SC_CLK_TCK by reflection", ex);
    }
}

