/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.devicebattery;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import com.facebook.battery.metrics.devicebattery.DeviceBatteryMetrics;
import com.facebook.infer.annotation.ThreadSafe;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class DeviceBatteryMetricsCollector
extends SystemMetricsCollector<DeviceBatteryMetrics> {
    private static final String TAG = "DeviceBatteryMetricsCollector";
    static int UNKNOWN_LEVEL = -1;
    private final Context mContext;
    @GuardedBy(value="this")
    long mBatteryRealtimeMs;
    @GuardedBy(value="this")
    long mChargingRealtimeMs;
    @GuardedBy(value="this")
    long mLastUpdateMs;
    @GuardedBy(value="this")
    boolean mIsCurrentlyCharging;

    public DeviceBatteryMetricsCollector(Context context) {
        this.mContext = context;
        this.mIsCurrentlyCharging = DeviceBatteryMetricsCollector.isCharging(this.getBatteryIntent());
        this.mLastUpdateMs = SystemClock.elapsedRealtime();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        intentFilter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        context.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                long now = SystemClock.elapsedRealtime();
                DeviceBatteryMetricsCollector deviceBatteryMetricsCollector = DeviceBatteryMetricsCollector.this;
                synchronized (deviceBatteryMetricsCollector) {
                    switch (intent.getAction()) {
                        case "android.intent.action.ACTION_POWER_CONNECTED": {
                            if (!DeviceBatteryMetricsCollector.this.mIsCurrentlyCharging) {
                                DeviceBatteryMetricsCollector.this.mBatteryRealtimeMs += now - DeviceBatteryMetricsCollector.this.mLastUpdateMs;
                            } else {
                                DeviceBatteryMetricsCollector.this.mChargingRealtimeMs += now - DeviceBatteryMetricsCollector.this.mLastUpdateMs;
                                DeviceBatteryMetricsCollector.this.logIncorrectSequence("CONNECTED", now);
                            }
                            DeviceBatteryMetricsCollector.this.mIsCurrentlyCharging = true;
                            break;
                        }
                        case "android.intent.action.ACTION_POWER_DISCONNECTED": {
                            if (DeviceBatteryMetricsCollector.this.mIsCurrentlyCharging) {
                                DeviceBatteryMetricsCollector.this.mChargingRealtimeMs += now - DeviceBatteryMetricsCollector.this.mLastUpdateMs;
                            } else {
                                DeviceBatteryMetricsCollector.this.mBatteryRealtimeMs += now - DeviceBatteryMetricsCollector.this.mLastUpdateMs;
                                DeviceBatteryMetricsCollector.this.logIncorrectSequence("DISCONNECTED", now);
                            }
                            DeviceBatteryMetricsCollector.this.mIsCurrentlyCharging = false;
                            break;
                        }
                    }
                    DeviceBatteryMetricsCollector.this.mLastUpdateMs = now;
                }
            }
        }, intentFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ThreadSafe(enableChecks=false)
    public boolean getSnapshot(DeviceBatteryMetrics snapshot) {
        Utilities.checkNotNull(snapshot, "Null value passed to getSnapshot!");
        snapshot.batteryLevelPct = DeviceBatteryMetricsCollector.getBatteryLevel(this.getBatteryIntent());
        long now = SystemClock.elapsedRealtime();
        DeviceBatteryMetricsCollector deviceBatteryMetricsCollector = this;
        synchronized (deviceBatteryMetricsCollector) {
            if (this.mIsCurrentlyCharging) {
                snapshot.chargingRealtimeMs = this.mChargingRealtimeMs + (now - this.mLastUpdateMs);
                snapshot.batteryRealtimeMs = this.mBatteryRealtimeMs;
            } else {
                snapshot.chargingRealtimeMs = this.mChargingRealtimeMs;
                snapshot.batteryRealtimeMs = this.mBatteryRealtimeMs + (now - this.mLastUpdateMs);
            }
            return true;
        }
    }

    @Override
    public DeviceBatteryMetrics createMetrics() {
        return new DeviceBatteryMetrics();
    }

    @Nullable
    private Intent getBatteryIntent() {
        try {
            return this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
        catch (Exception ex) {
            SystemMetricsLogger.wtf(TAG, "Exception registering receiver for ACTION_BATTERY_CHANGED");
            return null;
        }
    }

    private static float getBatteryLevel(@Nullable Intent batteryStatus) {
        if (batteryStatus == null) {
            return UNKNOWN_LEVEL;
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        if (level < 0 || scale <= 0) {
            return UNKNOWN_LEVEL;
        }
        return (float)level / (float)scale * 100.0f;
    }

    private static boolean isCharging(@Nullable Intent batteryStatus) {
        int status = batteryStatus != null ? batteryStatus.getIntExtra("status", -1) : -1;
        return status == 2 || status == 5;
    }

    void logIncorrectSequence(String intentType, long now) {
        SystemMetricsLogger.wtf(TAG, "Consecutive " + intentType + "broadcasts: (" + this.mLastUpdateMs + ", " + now + ")");
    }
}

