/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.healthstats;

import android.content.Context;
import android.os.health.SystemHealthManager;
import android.support.annotation.RequiresApi;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.healthstats.HealthStatsMetrics;
import com.facebook.infer.annotation.ThreadSafe;

@RequiresApi(api=24)
@ThreadSafe(enableChecks=false)
public class HealthStatsMetricsCollector
extends SystemMetricsCollector<HealthStatsMetrics> {
    private static final String TAG = "HealthStatsMetricsCollector";
    private final SystemHealthManager mSystemHealthManager;

    public HealthStatsMetricsCollector(Context context) {
        this.mSystemHealthManager = (SystemHealthManager)context.getSystemService("systemhealth");
    }

    @Override
    public boolean getSnapshot(HealthStatsMetrics snapshot) {
        try {
            snapshot.set(this.mSystemHealthManager.takeMyUidSnapshot());
            return true;
        }
        catch (RuntimeException e) {
            SystemMetricsLogger.wtf(TAG, "Unable to snapshot healthstats", e);
            return false;
        }
    }

    @Override
    public HealthStatsMetrics createMetrics() {
        return new HealthStatsMetrics();
    }
}

