/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.content.Context;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.network.EnhancedNetworkMetrics;
import com.facebook.battery.metrics.network.NetworkBytesCollector;
import com.facebook.battery.metrics.network.NetworkMetricsCollector;
import com.facebook.infer.annotation.ThreadSafe;

public class EnhancedNetworkMetricsCollector
extends SystemMetricsCollector<EnhancedNetworkMetrics> {
    private boolean mIsValid = true;
    private final NetworkBytesCollector mCollector;
    private final long[] mBytes;
    private final long[] mPrevBytes;

    public EnhancedNetworkMetricsCollector(Context context) {
        this.mCollector = NetworkBytesCollector.create(context);
        this.mBytes = NetworkBytesCollector.createByteArray();
        this.mPrevBytes = NetworkBytesCollector.createByteArray();
    }

    @Override
    @ThreadSafe(enableChecks=false)
    public synchronized boolean getSnapshot(EnhancedNetworkMetrics snapshot) {
        boolean supportsBgDetection;
        if (!this.mIsValid || !this.mCollector.getTotalBytes(this.mBytes)) {
            return false;
        }
        this.mIsValid = NetworkMetricsCollector.ensureBytesIncreased(this.mBytes, this.mPrevBytes);
        if (!this.mIsValid) {
            return false;
        }
        snapshot.supportsBgDetection = supportsBgDetection = this.mCollector.supportsBgDistinction();
        NetworkMetricsCollector.resetMetrics(snapshot.fgMetrics);
        NetworkMetricsCollector.addMetricsFromBytes(snapshot.fgMetrics, this.mBytes, 0);
        if (supportsBgDetection) {
            NetworkMetricsCollector.resetMetrics(snapshot.bgMetrics);
            NetworkMetricsCollector.addMetricsFromBytes(snapshot.bgMetrics, this.mBytes, 4);
        }
        return true;
    }

    @Override
    public EnhancedNetworkMetrics createMetrics() {
        return new EnhancedNetworkMetrics();
    }
}

