/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.app.usage.NetworkStats;
import android.app.usage.NetworkStatsManager;
import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.RequiresApi;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.network.NetworkBytesCollector;
import java.util.Arrays;

@RequiresApi(api=28)
public class NetworkStatsManagerBytesCollector
extends NetworkBytesCollector {
    private static final String TAG = "NetworkStatsManagerBytesCollector";
    private final NetworkStats.Bucket mBucket = new NetworkStats.Bucket();
    private final NetworkStatsManager mNetworkStatsManager;
    private final long mStartTime;

    public NetworkStatsManagerBytesCollector(Context context) {
        this.mNetworkStatsManager = (NetworkStatsManager)context.getSystemService(NetworkStatsManager.class);
        this.mStartTime = Long.MIN_VALUE;
    }

    @Override
    public boolean supportsBgDistinction() {
        return true;
    }

    @Override
    public boolean getTotalBytes(long[] bytes) {
        long endTimeMs = Long.MAX_VALUE;
        try {
            Arrays.fill(bytes, 0L);
            this.getBytesForType(bytes, 0, 2, this.mStartTime, endTimeMs);
            this.getBytesForType(bytes, 1, 0, this.mStartTime, endTimeMs);
            return true;
        }
        catch (RemoteException re) {
            SystemMetricsLogger.wtf(TAG, "Unable to get bytes transferred", re);
            return false;
        }
    }

    private void getBytesForType(long[] bytes, int connectivityManagerType, int type, long startTimeMs, long endTimeMs) throws RemoteException {
        NetworkStats stats = this.mNetworkStatsManager.querySummary(connectivityManagerType, null, startTimeMs, endTimeMs);
        while (stats.hasNextBucket()) {
            stats.getNextBucket(this.mBucket);
            int appState = this.mBucket.getState() == 2 ? 0 : 4;
            int n = type | 0 | appState;
            bytes[n] = bytes[n] + this.mBucket.getRxBytes();
            int n2 = type | 1 | appState;
            bytes[n2] = bytes[n2] + this.mBucket.getTxBytes();
        }
        stats.close();
    }
}

