/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.network.RadioStateMetrics;
import com.facebook.infer.annotation.ThreadSafe;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class RadioStateCollector
extends SystemMetricsCollector<RadioStateMetrics> {
    private static final int NONE = -1;
    private static final int WAKEUP_INTERVAL_S = 10;
    private final ConnectivityManager mConnectivityManager;
    private final RadioMonitor mWifiRadioMonitor = new RadioMonitor(0);
    private final RadioMonitor mMobileRadioMonitor = new RadioMonitor(10);

    public RadioStateCollector(Context context) {
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static int getNetworkType(NetworkInfo info) {
        return info == null ? -1 : info.getType();
    }

    @Override
    @ThreadSafe(enableChecks=false)
    public boolean getSnapshot(RadioStateMetrics snapshot) {
        long mobileNextIdleTimeActive = this.mMobileRadioMonitor.mNextIdleTimeActive.get();
        snapshot.mobileHighPowerActiveS = RadioMonitor.totalTxS(mobileNextIdleTimeActive);
        snapshot.mobileLowPowerActiveS = RadioMonitor.totalTailS(mobileNextIdleTimeActive);
        snapshot.mobileRadioWakeupCount = this.mMobileRadioMonitor.mWakeupCounter.get();
        long wifiNextIdleTimeActive = this.mWifiRadioMonitor.mNextIdleTimeActive.get();
        snapshot.wifiActiveS = RadioMonitor.totalTxS(wifiNextIdleTimeActive) + RadioMonitor.totalTailS(wifiNextIdleTimeActive);
        snapshot.wifiRadioWakeupCount = this.mWifiRadioMonitor.mWakeupCounter.get();
        return true;
    }

    @Override
    public RadioStateMetrics createMetrics() {
        return new RadioStateMetrics();
    }

    @Nullable
    private RadioMonitor getCurrentRadioMonitor() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        int currentNetworkType = RadioStateCollector.getNetworkType(info);
        switch (currentNetworkType) {
            case -1: {
                return null;
            }
            case 1: {
                return this.mWifiRadioMonitor;
            }
        }
        return this.mMobileRadioMonitor;
    }

    public void onRadioActiveNow() {
        RadioMonitor radioMonitor = this.getCurrentRadioMonitor();
        if (radioMonitor != null) {
            long timeMs = SystemClock.elapsedRealtime();
            radioMonitor.onRadioActivate(timeMs, timeMs);
        }
    }

    public void onRadioActive(long startTimeMs, long endTimeMs) {
        RadioMonitor radioMonitor = this.getCurrentRadioMonitor();
        if (radioMonitor != null) {
            radioMonitor.onRadioActivate(startTimeMs, endTimeMs);
        }
    }

    @ThreadSafe
    static final class RadioMonitor {
        private final int mWakeUpTimeS;
        final AtomicLong mNextIdleTimeActive = new AtomicLong();
        final AtomicInteger mWakeupCounter = new AtomicInteger();

        public RadioMonitor(int wakeUpTimeS) {
            this.mWakeUpTimeS = wakeUpTimeS;
        }

        public int onRadioActivate(long transferStartMs, long transferEndMs) {
            long newNextIdleAndTotals;
            long expectedNextIdleAndTotals;
            long transferStartS = TimeUnit.MILLISECONDS.toSeconds(transferStartMs);
            long transferEndS = TimeUnit.MILLISECONDS.toSeconds(transferEndMs);
            boolean casSucceeded = false;
            do {
                expectedNextIdleAndTotals = this.mNextIdleTimeActive.get();
                newNextIdleAndTotals = this.adjustTotalsAndNextIdle(transferStartS, transferEndS, expectedNextIdleAndTotals);
            } while (RadioMonitor.nextIdle(expectedNextIdleAndTotals) < RadioMonitor.nextIdle(newNextIdleAndTotals) && !(casSucceeded = this.mNextIdleTimeActive.compareAndSet(expectedNextIdleAndTotals, newNextIdleAndTotals)));
            if (casSucceeded) {
                if (RadioMonitor.nextIdle(expectedNextIdleAndTotals) <= transferStartS) {
                    this.mWakeupCounter.getAndIncrement();
                }
                return RadioMonitor.totalTxS(expectedNextIdleAndTotals) + RadioMonitor.totalTailS(expectedNextIdleAndTotals);
            }
            return 0;
        }

        private long adjustTotalsAndNextIdle(long transferStartS, long transferEndS, long nextIdleAndTotals) {
            long nextIdle = RadioMonitor.nextIdle(nextIdleAndTotals);
            long oldTransferEnd = nextIdle - (long)this.mWakeUpTimeS;
            long transferDeltaAdjustment = transferEndS > oldTransferEnd ? 1L : 0L;
            transferStartS = Math.max(transferStartS, oldTransferEnd);
            transferEndS = Math.max(transferEndS, oldTransferEnd);
            long oldTransferTotal = RadioMonitor.totalTxS(nextIdleAndTotals);
            long oldTailTotal = RadioMonitor.totalTailS(nextIdleAndTotals);
            long transferDelta = Math.max(transferEndS - transferStartS, transferDeltaAdjustment);
            long tailDelta = transferStartS < nextIdle ? (transferEndS < nextIdle ? (long)this.mWakeUpTimeS - transferDelta - (nextIdle - transferEndS) : (long)this.mWakeUpTimeS - (nextIdle - transferStartS)) : (long)this.mWakeUpTimeS;
            return RadioMonitor.makeIdleValue(transferEndS + (long)this.mWakeUpTimeS, oldTransferTotal + transferDelta, oldTailTotal + tailDelta);
        }

        static long makeIdleValue(long nextIdleS, long totalTransferS, long totalTailS) {
            return nextIdleS << 32 | totalTransferS << 16 | totalTailS;
        }

        static long nextIdle(long nextIdleTimeActive) {
            return nextIdleTimeActive >> 32;
        }

        static int totalTxS(long nextIdleTimeActive) {
            return (int)((nextIdleTimeActive & 0xFFFF0000L) >> 16);
        }

        static int totalTailS(long nextIdleTimeActive) {
            return (int)(nextIdleTimeActive & 0xFFFFL);
        }
    }
}

