/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.wakelock;

import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import org.json.JSONException;
import org.json.JSONObject;

public class WakeLockMetrics
extends SystemMetrics<WakeLockMetrics> {
    public boolean isAttributionEnabled;
    public final SimpleArrayMap<String, Long> tagTimeMs = new SimpleArrayMap();
    public long heldTimeMs;
    public long acquiredCount;

    public WakeLockMetrics() {
        this(false);
    }

    public WakeLockMetrics(boolean isAttributionEnabled) {
        this.isAttributionEnabled = isAttributionEnabled;
    }

    @Override
    public WakeLockMetrics sum(@Nullable WakeLockMetrics b, @Nullable WakeLockMetrics output) {
        if (output == null) {
            output = new WakeLockMetrics(this.isAttributionEnabled);
        }
        if (b == null) {
            output.set(this);
        } else {
            output.heldTimeMs = this.heldTimeMs + b.heldTimeMs;
            output.acquiredCount = this.acquiredCount + b.acquiredCount;
            if (output.isAttributionEnabled) {
                String tag;
                int i;
                output.tagTimeMs.clear();
                int size = this.tagTimeMs.size();
                for (i = 0; i < size; ++i) {
                    tag = (String)this.tagTimeMs.keyAt(i);
                    Long currentTimeMs = (Long)b.tagTimeMs.get((Object)tag);
                    output.tagTimeMs.put((Object)tag, (Object)((Long)this.tagTimeMs.valueAt(i) + (currentTimeMs == null ? 0L : currentTimeMs)));
                }
                size = b.tagTimeMs.size();
                for (i = 0; i < size; ++i) {
                    tag = (String)b.tagTimeMs.keyAt(i);
                    if (this.tagTimeMs.get((Object)tag) != null) continue;
                    output.tagTimeMs.put((Object)tag, b.tagTimeMs.valueAt(i));
                }
            }
        }
        return output;
    }

    @Override
    public WakeLockMetrics diff(@Nullable WakeLockMetrics b, @Nullable WakeLockMetrics output) {
        if (output == null) {
            output = new WakeLockMetrics(this.isAttributionEnabled);
        }
        if (b == null) {
            output.set(this);
        } else {
            output.heldTimeMs = this.heldTimeMs - b.heldTimeMs;
            output.acquiredCount = this.acquiredCount - b.acquiredCount;
            if (output.isAttributionEnabled) {
                output.tagTimeMs.clear();
                int size = this.tagTimeMs.size();
                for (int i = 0; i < size; ++i) {
                    String tag = (String)this.tagTimeMs.keyAt(i);
                    Long currentTimeMs = (Long)b.tagTimeMs.get((Object)tag);
                    long difference = (Long)this.tagTimeMs.valueAt(i) - (currentTimeMs == null ? 0L : currentTimeMs);
                    if (difference == 0L) continue;
                    output.tagTimeMs.put((Object)tag, (Object)difference);
                }
            }
        }
        return output;
    }

    @Override
    public WakeLockMetrics set(WakeLockMetrics b) {
        this.heldTimeMs = b.heldTimeMs;
        this.acquiredCount = b.acquiredCount;
        if (b.isAttributionEnabled && this.isAttributionEnabled) {
            this.tagTimeMs.clear();
            this.tagTimeMs.putAll(b.tagTimeMs);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WakeLockMetrics that = (WakeLockMetrics)o;
        if (this.isAttributionEnabled != that.isAttributionEnabled || this.heldTimeMs != that.heldTimeMs || this.acquiredCount != that.acquiredCount) {
            return false;
        }
        return Utilities.simpleArrayMapEquals(this.tagTimeMs, that.tagTimeMs);
    }

    public int hashCode() {
        int result = this.isAttributionEnabled ? 1 : 0;
        result = 31 * result + this.tagTimeMs.hashCode();
        result = 31 * result + (int)(this.heldTimeMs ^ this.heldTimeMs >>> 32);
        result = 31 * result + (int)(this.acquiredCount ^ this.acquiredCount >>> 32);
        return result;
    }

    public String toString() {
        return "WakeLockMetrics{isAttributionEnabled=" + this.isAttributionEnabled + ", tagTimeMs=" + this.tagTimeMs + ", heldTimeMs=" + this.heldTimeMs + ", acquiredCount=" + this.acquiredCount + '}';
    }

    @Nullable
    public JSONObject attributionToJSONObject() {
        if (!this.isAttributionEnabled) {
            return null;
        }
        try {
            JSONObject attribution = new JSONObject();
            int size = this.tagTimeMs.size();
            for (int i = 0; i < size; ++i) {
                long currentTagTimeMs = (Long)this.tagTimeMs.valueAt(i);
                if (currentTagTimeMs <= 0L) continue;
                attribution.put((String)this.tagTimeMs.keyAt(i), currentTagTimeMs);
            }
            return attribution;
        }
        catch (JSONException ex) {
            SystemMetricsLogger.wtf("WakeLockMetrics", "Failed to serialize attribution data", ex);
            return null;
        }
    }
}

