/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.debug;

import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.CacheKeyUtil;
import com.facebook.drawee.backends.pipeline.info.ImagePerfData;
import com.facebook.drawee.backends.pipeline.info.ImagePerfDataListener;
import com.facebook.imagepipeline.debug.DebugImageTracker;
import com.facebook.imagepipeline.debug.LruMap;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FlipperImageTracker
implements DebugImageTracker,
ImagePerfDataListener {
    private static final int MAX_IMAGES_TO_TRACK = 200;
    private final Map<ImageRequest, ImageDebugData> mImageRequestDebugDataMap = new LruMap<ImageRequest, ImageDebugData>(200);
    private final Map<CacheKey, ImageDebugData> mImageDebugDataMap = new LruMap<CacheKey, ImageDebugData>(200);

    @Override
    public synchronized void trackImage(ImageRequest imageRequest, CacheKey cacheKey) {
        ImageDebugData imageDebugData = this.mImageRequestDebugDataMap.get(imageRequest);
        if (imageDebugData == null) {
            imageDebugData = new ImageDebugData(imageRequest);
            this.mImageDebugDataMap.put(cacheKey, imageDebugData);
            this.mImageRequestDebugDataMap.put(imageRequest, imageDebugData);
        }
        imageDebugData.addCacheKey(cacheKey);
        imageDebugData.addResourceId(CacheKeyUtil.getFirstResourceId((CacheKey)cacheKey));
    }

    @Override
    public synchronized void trackImageRequest(ImageRequest imageRequest, String requestId) {
        ImageDebugData imageDebugData = this.mImageRequestDebugDataMap.get(imageRequest);
        if (imageDebugData == null) {
            imageDebugData = new ImageDebugData(imageRequest);
            this.mImageRequestDebugDataMap.put(imageRequest, imageDebugData);
        }
        imageDebugData.addRequestId(requestId);
    }

    public synchronized ImageDebugData trackImage(String localPath, CacheKey key) {
        ImageDebugData data = new ImageDebugData(localPath);
        this.mImageDebugDataMap.put(key, data);
        return data;
    }

    public synchronized ImageDebugData trackImage(CacheKey key) {
        ImageDebugData data = new ImageDebugData();
        this.mImageDebugDataMap.put(key, data);
        return data;
    }

    public synchronized String getUriString(CacheKey key) {
        ImageRequest imageRequest;
        ImageDebugData imageDebugData = this.getImageDebugData(key);
        if (imageDebugData != null && (imageRequest = imageDebugData.getImageRequest()) != null) {
            return imageRequest.getSourceUri().toString();
        }
        return key.getUriString();
    }

    @Nullable
    public synchronized String getLocalPath(CacheKey key) {
        ImageDebugData imageDebugData = this.getImageDebugData(key);
        if (imageDebugData != null) {
            return imageDebugData.getLocalPath();
        }
        return null;
    }

    @Nullable
    public synchronized ImageDebugData getImageDebugData(CacheKey key) {
        return this.mImageDebugDataMap.get(key);
    }

    @Nullable
    public synchronized ImageDebugData getDebugDataForRequestId(String requestId) {
        for (ImageDebugData debugData : this.mImageRequestDebugDataMap.values()) {
            Set<String> requestIds = debugData.getRequestIds();
            if (requestIds == null || !requestIds.contains(requestId)) continue;
            return debugData;
        }
        return null;
    }

    @Nullable
    public synchronized ImageDebugData getDebugDataForResourceId(String resourceId) {
        for (ImageDebugData debugData : this.mImageRequestDebugDataMap.values()) {
            Set<String> ids = debugData.getResourceIds();
            if (ids == null || !ids.contains(resourceId)) continue;
            return debugData;
        }
        return null;
    }

    @Nullable
    public synchronized CacheKey getCacheKey(String imageId) {
        for (Map.Entry<CacheKey, ImageDebugData> entry : this.mImageDebugDataMap.entrySet()) {
            if (!entry.getValue().getUniqueId().equals(imageId)) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized void onImageLoadStatusUpdated(ImagePerfData imagePerfData, int imageLoadStatus) {
        if (imagePerfData == null || imagePerfData.getImageRequest() == null) {
            return;
        }
        if (this.mImageRequestDebugDataMap.containsKey(imagePerfData.getImageRequest())) {
            this.mImageRequestDebugDataMap.get(imagePerfData.getImageRequest()).setImagePerfData(imagePerfData);
        } else {
            ImageDebugData imageDebugData = new ImageDebugData(imagePerfData.getImageRequest());
            imageDebugData.setImagePerfData(imagePerfData);
            this.mImageRequestDebugDataMap.put(imagePerfData.getImageRequest(), imageDebugData);
        }
    }

    public synchronized void onImageVisibilityUpdated(ImagePerfData imagePerfData, int visibilityState) {
    }

    public static class ImageDebugData {
        @Nullable
        private final ImageRequest mImageRequest;
        @Nullable
        private ImagePerfData mImagePerfData;
        @Nullable
        private Set<CacheKey> mCacheKeys;
        @Nullable
        private Set<String> mRequestIds;
        @Nullable
        private Set<String> mResourceIds;
        @Nullable
        private String mLocalPath;

        public ImageDebugData() {
            this(null, null);
        }

        public ImageDebugData(@Nullable ImageRequest imageRequest) {
            this(imageRequest, null);
        }

        public ImageDebugData(@Nullable String localPath) {
            this(null, localPath);
        }

        public ImageDebugData(@Nullable ImageRequest imageRequest, @Nullable String localPath) {
            this.mImageRequest = imageRequest;
            this.mLocalPath = localPath;
        }

        @Nullable
        public ImageRequest getImageRequest() {
            return this.mImageRequest;
        }

        @Nullable
        public Set<CacheKey> getCacheKeys() {
            return this.mCacheKeys;
        }

        public void addCacheKey(CacheKey cacheKey) {
            if (this.mCacheKeys == null) {
                this.mCacheKeys = new HashSet<CacheKey>();
            }
            this.mCacheKeys.add(cacheKey);
        }

        @Nullable
        public Set<String> getRequestIds() {
            return this.mRequestIds;
        }

        public String getUniqueId() {
            return Integer.toString(this.hashCode());
        }

        public void addRequestId(String requestId) {
            if (this.mRequestIds == null) {
                this.mRequestIds = new HashSet<String>();
            }
            this.mRequestIds.add(requestId);
        }

        public void addResourceId(String resourceId) {
            if (resourceId == null) {
                return;
            }
            if (this.mResourceIds == null) {
                this.mResourceIds = new HashSet<String>();
            }
            this.mResourceIds.add(resourceId);
        }

        @Nullable
        public ImagePerfData getImagePerfData() {
            return this.mImagePerfData;
        }

        public void setImagePerfData(@Nullable ImagePerfData imagePerfData) {
            this.mImagePerfData = imagePerfData;
        }

        @Nullable
        public Set<String> getResourceIds() {
            return this.mResourceIds;
        }

        @Nullable
        public String getLocalPath() {
            return this.mLocalPath;
        }
    }
}

