/*
 * Decompiled with CFR 0.152.
 */
package com.transtech.geniex;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.transtech.geniex.ICallback;
import com.transtech.geniex.IVsimStateListener;

public interface IVsimManager
extends IInterface {
    public static final String DESCRIPTOR = "com.transtech.geniex.IVsimManager";

    public String getUserInfo() throws RemoteException;

    public void login(String var1, int var2, String var3, String var4, String var5, int var6, ICallback var7) throws RemoteException;

    public void register(String var1, int var2, String var3, String var4, String var5, String var6, ICallback var7) throws RemoteException;

    public String getState() throws RemoteException;

    public String getMaintenance() throws RemoteException;

    public void registerListener(IVsimStateListener var1) throws RemoteException;

    public void unRegisterListener(IVsimStateListener var1) throws RemoteException;

    public void stats(String var1, String var2) throws RemoteException;

    public int enableVsim(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVsimManager {
        static final int TRANSACTION_getUserInfo = 1;
        static final int TRANSACTION_login = 2;
        static final int TRANSACTION_register = 3;
        static final int TRANSACTION_getState = 4;
        static final int TRANSACTION_getMaintenance = 5;
        static final int TRANSACTION_registerListener = 6;
        static final int TRANSACTION_unRegisterListener = 7;
        static final int TRANSACTION_stats = 8;
        static final int TRANSACTION_enableVsim = 9;

        public Stub() {
            this.attachInterface(this, IVsimManager.DESCRIPTOR);
        }

        public static IVsimManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVsimManager.DESCRIPTOR);
            if (iin != null && iin instanceof IVsimManager) {
                return (IVsimManager)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVsimManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _result = this.getUserInfo();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    ICallback _arg6 = ICallback.Stub.asInterface(data.readStrongBinder());
                    this.login(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    ICallback _arg6 = ICallback.Stub.asInterface(data.readStrongBinder());
                    this.register(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _result = this.getState();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    String _result = this.getMaintenance();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 6: {
                    IVsimStateListener _arg0 = IVsimStateListener.Stub.asInterface(data.readStrongBinder());
                    this.registerListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IVsimStateListener _arg0 = IVsimStateListener.Stub.asInterface(data.readStrongBinder());
                    this.unRegisterListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.stats(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    boolean _arg0 = 0 != data.readInt();
                    int _result = this.enableVsim(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IVsimManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVsimManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getUserInfo() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void login(String appId, int version, String cc, String phone, String passOrCaptcha, int type, ICallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    _data.writeString(appId);
                    _data.writeInt(version);
                    _data.writeString(cc);
                    _data.writeString(phone);
                    _data.writeString(passOrCaptcha);
                    _data.writeInt(type);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void register(String appId, int version, String cc, String phone, String pass, String captcha, ICallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    _data.writeString(appId);
                    _data.writeInt(version);
                    _data.writeString(cc);
                    _data.writeString(phone);
                    _data.writeString(pass);
                    _data.writeString(captcha);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getState() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getMaintenance() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(IVsimStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)listener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unRegisterListener(IVsimStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)listener);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stats(String key, String values) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeString(values);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enableVsim(boolean enable) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVsimManager.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IVsimManager {
        @Override
        public String getUserInfo() throws RemoteException {
            return null;
        }

        @Override
        public void login(String appId, int version, String cc, String phone, String passOrCaptcha, int type, ICallback callback) throws RemoteException {
        }

        @Override
        public void register(String appId, int version, String cc, String phone, String pass, String captcha, ICallback callback) throws RemoteException {
        }

        @Override
        public String getState() throws RemoteException {
            return null;
        }

        @Override
        public String getMaintenance() throws RemoteException {
            return null;
        }

        @Override
        public void registerListener(IVsimStateListener listener) throws RemoteException {
        }

        @Override
        public void unRegisterListener(IVsimStateListener listener) throws RemoteException {
        }

        @Override
        public void stats(String key, String values) throws RemoteException {
        }

        @Override
        public int enableVsim(boolean enable) throws RemoteException {
            return 0;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

