/*
 * Decompiled with CFR 0.152.
 */
package com.transtech.geniex.utils;

import android.content.Context;
import android.os.LocaleList;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.transtech.geniex.R;
import com.transtech.geniex.utils.Area;
import com.transtech.geniex.utils.SystemUtilKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\nR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/transtech/geniex/utils/AreaCodes;", "", "()V", "DATA", "", "Lcom/transtech/geniex/utils/Area;", "getDATA", "()[Lcom/transtech/geniex/utils/Area;", "[Lcom/transtech/geniex/utils/Area;", "cc2Mcc", "", "cc", "get", "context", "Landroid/content/Context;", "area", "getWithMcc", "mcc", "sdk_release"})
public final class AreaCodes {
    @NotNull
    public static final AreaCodes INSTANCE = new AreaCodes();
    @NotNull
    private static final Area[] DATA;

    private AreaCodes() {
    }

    @NotNull
    public final String get(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String country = SystemUtilKt.getProp("persist.sys.oobe_country");
        if (TextUtils.isEmpty((CharSequence)country)) {
            Object object = context.getSystemService("phone");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
            TelephonyManager tm = (TelephonyManager)object;
            String string2 = tm.getNetworkCountryIso();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNetworkCountryIso(...)");
            country = string2;
            if (TextUtils.isEmpty((CharSequence)country)) {
                String string3 = LocaleList.getDefault().get(0).getCountry();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCountry(...)");
                country = string3;
            }
        }
        String string4 = country.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return this.get(string4);
    }

    @NotNull
    public final String get(@NotNull String area) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        if (!TextUtils.isEmpty((CharSequence)area)) {
            for (Area a : DATA) {
                if (!Intrinsics.areEqual((Object)area, (Object)a.getRegion())) continue;
                return a.getCc();
            }
        }
        return "+234";
    }

    @Nullable
    public final String getWithMcc(@NotNull String mcc) {
        Intrinsics.checkNotNullParameter((Object)mcc, (String)"mcc");
        return switch (mcc) {
            case "621" -> "+234";
            case "620" -> "+233";
            case "460", "461" -> "+86";
            default -> null;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String cc2Mcc(@NotNull String cc) {
        Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
        String string2 = cc;
        switch (string2.hashCode()) {
            case 1330695: {
                if (string2.equals("+233")) return "620";
                return null;
            }
            case 43113: {
                if (string2.equals("+86")) return "460";
                return null;
            }
            case 1330696: {
                if (!string2.equals("+234")) return null;
                return "621";
            }
        }
        return null;
    }

    @NotNull
    public final Area[] getDATA() {
        return DATA;
    }

    static {
        Area[] areaArray = new Area[]{new Area("NG", "Nigeria", "+234", R.drawable.gx_ic_ng_flag), new Area("CN", "China", "+86", R.drawable.gx_ic_cn_flag)};
        DATA = areaArray;
    }
}

