/*
 * Decompiled with CFR 0.152.
 */
package com.transtech.geniex.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import com.transtech.geniex.utils.Logger;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u0006\u0010\u0011\u001a\u00020\t\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0006\u0010\u001a\u001a\u00020\u0001\u00a8\u0006\u001b"}, d2={"displayCountry", "", "l", "formatBytes", "size", "", "precise", "", "getAppVersion", "", "pm", "Landroid/content/pm/PackageManager;", "pkg", "getIcon", "context", "Landroid/content/Context;", "getMcc", "getOSIVersion", "getProp", "property", "isAutoStart", "locale", "md5", "src", "setAutoStartEnable", "enable", "timezone", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nSystemUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemUtil.kt\ncom/transtech/geniex/utils/SystemUtilKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,183:1\n37#2,2:184\n*S KotlinDebug\n*F\n+ 1 SystemUtil.kt\ncom/transtech/geniex/utils/SystemUtilKt\n*L\n130#1:184,2\n*E\n"})
public final class SystemUtilKt {
    @NotNull
    public static final String locale() {
        Object object;
        Locale locale = LocaleList.getDefault().get(0);
        if (TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            String string2 = locale.getLanguage();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguage(...)");
        } else {
            object = locale.getLanguage() + "_" + locale.getCountry();
        }
        return object;
    }

    @NotNull
    public static final String displayCountry(@Nullable String l) {
        Locale locale = null;
        if (l != null) {
            try {
                char[] cArray = new char[]{'_'};
                List spit = StringsKt.split$default((CharSequence)l, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (spit.size() == 2) {
                    locale = new Locale.Builder().setLanguage((String)spit.get(0)).setRegion((String)spit.get(1)).build();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (locale == null) {
            locale = LocaleList.getDefault().get(0);
        }
        Locale locale2 = locale;
        String string2 = locale2 != null ? locale2.getDisplayCountry() : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public static final String timezone() {
        Object zone = "";
        try {
            String displayName = TimeZone.getDefault().getDisplayName(false, 0);
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                Intrinsics.checkNotNull((Object)displayName);
                if (StringsKt.contains$default((CharSequence)displayName, (CharSequence)"+", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{":"};
                    String name = (String)StringsKt.split$default((CharSequence)StringsKt.replace$default((String)displayName, (String)"GMT+", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
                    if (StringsKt.startsWith$default((String)name, (String)"0", (boolean)false, (int)2, null)) {
                        name = StringsKt.replace$default((String)name, (String)"0", (String)"", (boolean)false, (int)4, null);
                    }
                    zone = "GMT+" + name;
                } else if (StringsKt.contains$default((CharSequence)displayName, (CharSequence)"-", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{"-"};
                    CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)displayName, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                    stringArray = new String[]{":"};
                    String name = (String)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
                    if (StringsKt.startsWith$default((String)name, (String)"0", (boolean)false, (int)2, null)) {
                        name = StringsKt.replace$default((String)name, (String)"0", (String)"", (boolean)false, (int)4, null);
                    }
                    zone = "GMT-" + name;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return zone;
    }

    public static final boolean isAutoStart(@NotNull Context context, @NotNull String pkg) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager am = (ActivityManager)object;
        Class<?> mActivityManager = am.getClass();
        List mCleanProList = null;
        try {
            method = mActivityManager.getMethod("getAutoStartList", new Class[0]);
            Object object2 = method.invoke((Object)am, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String?>");
            mCleanProList = (List)object2;
        }
        catch (Exception e) {
            Logger.INSTANCE.d("getAutoStartList", e);
        }
        String string2 = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BRAND");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"ITEL", (boolean)false, (int)2, null)) {
            try {
                method = mActivityManager.getMethod("getForbiddenAutoRunPackages", new Class[0]);
                Object object3 = method.invoke((Object)am, new Object[0]);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String?>");
                mCleanProList = (List)object3;
            }
            catch (Exception e) {
                Logger.INSTANCE.d("getForbiddenAutoRunPackages", e);
            }
        }
        if (mCleanProList == null) {
            mCleanProList = new ArrayList();
        }
        return mCleanProList.contains(pkg);
    }

    public static final boolean setAutoStartEnable(@NotNull Context context, @Nullable String pkg, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager am = (ActivityManager)object;
        Class<?> mActivityManager = am.getClass();
        try {
            Object[] objectArray = new Class[]{String.class, Boolean.TYPE};
            Method method = mActivityManager.getMethod("setAutoStartEnable", (Class<?>[])objectArray);
            objectArray = new Object[]{pkg, enable};
            method.invoke((Object)am, objectArray);
            return true;
        }
        catch (Exception e) {
            Logger.INSTANCE.d("setAutoStartEnable", e);
            String string2 = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BRAND");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"ITEL", (boolean)false, (int)2, null)) {
                try {
                    Object[] objectArray = new Class[]{String.class, Boolean.TYPE};
                    Method method = mActivityManager.getMethod("setForbiddenAutoRunPackages", (Class<?>[])objectArray);
                    objectArray = new Object[]{pkg, enable};
                    method.invoke((Object)am, objectArray);
                    return true;
                }
                catch (Exception e2) {
                    Logger.INSTANCE.d("setForbiddenAutoRunPackages", e2);
                }
            }
            return false;
        }
    }

    public static final int getAppVersion(@NotNull PackageManager pm, @NotNull String pkg) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        try {
            PackageInfo info = pm.getPackageInfo(pkg, 0);
            return info.versionCode;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @NotNull
    public static final String getProp(@NotNull String property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getDeclaredMethod("get", classArray);
            Object[] objectArray = new Object[]{property};
            Object value = method.invoke(null, objectArray);
            if (value instanceof String) {
                return (String)value;
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e("getprop", e);
        }
        return "";
    }

    public static final int getOSIVersion() {
        try {
            String version = SystemUtilKt.getProp("sys.skyroam.osi.version");
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            if (split.length >= 4) {
                return 10000 * Integer.parseInt(split[2]) + Integer.parseInt(split[3]);
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    @NotNull
    public static final String getMcc() {
        String mcc = SystemUtilKt.getProp("sys.skyroam.silver.plmn");
        if (mcc.length() >= 3) {
            String string2 = mcc.substring(0, 3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            mcc = string2;
        }
        return mcc;
    }

    @NotNull
    public static final String md5(@NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (TextUtils.isEmpty((CharSequence)src)) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string2 = src;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes = messageDigest.digest(byArray);
            StringBuilder sb = new StringBuilder();
            Intrinsics.checkNotNull((Object)bytes);
            for (byte b : bytes) {
                String string3 = "%02x";
                Object[] objectArray = new Object[]{b};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                sb.append(string4);
            }
            String string5 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            String string6 = string5.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toUpperCase()");
            return string6;
        }
        catch (Exception exception) {
            return "";
        }
    }

    @NotNull
    public static final String formatBytes(long size, boolean precise) {
        Object object;
        long k = size / (long)1024;
        long m = k >= 1024L ? (k + (long)512) / (long)1024 : 0L;
        long g = m >= 1024L ? (m + (long)512) / (long)1024 : 0L;
        if (g > 0L) {
            Locale locale = Locale.ENGLISH;
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf((float)m / 1024.0f)};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
            object = string3 + "GB";
        } else if (m > 0L) {
            Locale locale = Locale.ENGLISH;
            String string4 = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf((float)k / 1024.0f)};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, format, *args)");
            object = string5 + "MB";
        } else {
            object = k > 0L ? k + "KB" : (precise ? "0KB" : "0MB");
        }
        return object;
    }

    public static /* synthetic */ String formatBytes$default(long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return SystemUtilKt.formatBytes(l, bl);
    }

    public static final int getIcon(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"getApplicationInfo(...)");
            ApplicationInfo info = applicationInfo;
            return info.metaData.getInt("com.transtech.geniex.slogan_icon");
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

