/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.CharacterSet;
import com.github.marschall.memoryfilesystem.GlobPathMatcher;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import com.github.marschall.memoryfilesystem.NamedRoot;
import com.github.marschall.memoryfilesystem.PathParser;
import com.github.marschall.memoryfilesystem.Root;
import com.github.marschall.memoryfilesystem.StringTransformer;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class MultipleNamedRootsPathParser
extends PathParser {
    private final StringTransformer pathTransformer;

    MultipleNamedRootsPathParser(String separator, StringTransformer pathTransformer, CharacterSet forbiddenCharacters) {
        super(separator, forbiddenCharacters);
        this.pathTransformer = pathTransformer;
    }

    @Override
    AbstractPath parseUri(Map<String, Root> rootByKey, String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            if (uri.charAt(i) == '/') continue;
            return this.parse(rootByKey, uri.substring(i), EMPTY);
        }
        throw new InvalidPathException(uri, "not a valid path: ");
    }

    @Override
    public AbstractPath parse(Map<String, Root> roots, String first, String ... more) {
        if (this.startWithSeparator(first, more)) {
            throw new InvalidPathException(first, "path must not start with separator", 1);
        }
        List<String> elements = new ArrayList<String>();
        this.parseInto(first, elements);
        if (more != null && more.length > 0) {
            for (String s : more) {
                this.parseInto(s, elements);
            }
        }
        MemoryFileSystem memoryFileSystem = this.getFileSystem(roots);
        if (this.isAbsolute(elements)) {
            Root root = this.getRoot(memoryFileSystem, roots, elements);
            elements = elements.subList(1, elements.size());
            this.check(elements);
            return AbstractPath.createAboslute(memoryFileSystem, root, elements);
        }
        this.check(elements);
        return AbstractPath.createRelative(memoryFileSystem, elements);
    }

    @Override
    PathMatcher parseGlob(String pattern) {
        if (this.startWithSeparator(pattern)) {
            throw new InvalidPathException(pattern, "path must not start with separator", 1);
        }
        List<String> elements = new ArrayList<String>();
        this.parseInto(pattern, elements);
        if (this.isAbsolute(elements)) {
            elements = elements.subList(1, elements.size());
            return new GlobPathMatcher(true, MultipleNamedRootsPathParser.convertToPatterns(elements));
        }
        return new GlobPathMatcher(false, MultipleNamedRootsPathParser.convertToPatterns(elements));
    }

    private MemoryFileSystem getFileSystem(Map<String, Root> roots) {
        return roots.values().iterator().next().getMemoryFileSystem();
    }

    private Root getRoot(MemoryFileSystem memoryFileSystem, Map<String, Root> roots, List<String> elements) {
        String first = elements.get(0);
        String key = this.pathTransformer.transform(first.substring(0, 1));
        Root root = roots.get(key);
        if (root != null) {
            return root;
        }
        return new NamedRoot(memoryFileSystem, key);
    }

    private boolean isAbsolute(List<String> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        String first = elements.get(0);
        return first.length() == 2 && first.charAt(1) == ':';
    }

    private void parseInto(String s, List<String> elements) {
        if (s.isEmpty()) {
            return;
        }
        int fromIndex = 0;
        int slashIndex = s.indexOf(47, fromIndex);
        int separatorIndex = s.indexOf(this.separator, fromIndex);
        int nextIndex = this.computeNextIndex(slashIndex, separatorIndex);
        while (nextIndex != -1) {
            if (nextIndex > fromIndex) {
                elements.add(s.substring(fromIndex, nextIndex));
            }
            fromIndex = nextIndex + 1;
            if (slashIndex == -1) {
                nextIndex = slashIndex = s.indexOf(this.separator, separatorIndex + 1);
                continue;
            }
            if (separatorIndex == -1) {
                nextIndex = separatorIndex = s.indexOf(47, slashIndex + 1);
                continue;
            }
            if (slashIndex < separatorIndex) {
                slashIndex = s.indexOf(47, slashIndex + 1);
            } else {
                separatorIndex = s.indexOf(this.separator, separatorIndex + 1);
            }
            nextIndex = this.computeNextIndex(slashIndex, separatorIndex);
        }
        if (fromIndex < s.length()) {
            elements.add(s.substring(fromIndex));
        }
    }

    private int computeNextIndex(int slashIndex, int separatorIndex) {
        if (slashIndex == -1) {
            return separatorIndex;
        }
        if (separatorIndex == -1) {
            return slashIndex;
        }
        return Math.min(slashIndex, separatorIndex);
    }
}

