/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.ClusterChain;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectory;
import com.github.mjdev.libaums.fs.fat32.FatLfnDirectoryEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FatFile
implements UsbFile {
    private BlockDeviceDriver blockDevice;
    private FAT fat;
    private Fat32BootSector bootSector;
    private FatDirectory parent;
    private ClusterChain chain;
    private FatLfnDirectoryEntry entry;

    private FatFile(BlockDeviceDriver blockDevice, FAT fat, Fat32BootSector bootSector, FatLfnDirectoryEntry entry, FatDirectory parent) {
        this.blockDevice = blockDevice;
        this.fat = fat;
        this.bootSector = bootSector;
        this.entry = entry;
        this.parent = parent;
    }

    public static FatFile create(FatLfnDirectoryEntry entry, BlockDeviceDriver blockDevice, FAT fat, Fat32BootSector bootSector, FatDirectory parent) throws IOException {
        return new FatFile(blockDevice, fat, bootSector, entry, parent);
    }

    private void initChain() throws IOException {
        if (this.chain == null) {
            this.chain = new ClusterChain(this.entry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
    }

    @Override
    public UsbFile search(String path) {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public void setName(String newName) throws IOException {
        this.parent.renameEntry(this.entry, newName);
    }

    @Override
    public long createdAt() {
        return this.entry.getActualEntry().getCreatedDateTime();
    }

    @Override
    public long lastModified() {
        return this.entry.getActualEntry().getLastModifiedDateTime();
    }

    @Override
    public long lastAccessed() {
        return this.entry.getActualEntry().getLastAccessedDateTime();
    }

    @Override
    public UsbFile getParent() {
        return this.parent;
    }

    @Override
    public String[] list() {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public UsbFile[] listFiles() throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public long getLength() {
        return this.entry.getFileSize();
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.initChain();
        this.chain.setLength(newLength);
        this.entry.setFileSize(newLength);
    }

    @Override
    public void read(long offset, ByteBuffer destination) throws IOException {
        this.initChain();
        this.entry.setLastAccessedTimeToNow();
        this.chain.read(offset, destination);
    }

    @Override
    public void write(long offset, ByteBuffer source) throws IOException {
        this.initChain();
        long length = offset + (long)source.remaining();
        if (length > this.getLength()) {
            this.setLength(length);
        }
        this.entry.setLastModifiedTimeToNow();
        this.chain.write(offset, source);
    }

    @Override
    public void flush() throws IOException {
        this.parent.write();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public UsbFile createDirectory(String name) throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public UsbFile createFile(String name) throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public void moveTo(UsbFile destination) throws IOException {
        this.parent.move(this.entry, destination);
        this.parent = (FatDirectory)destination;
    }

    @Override
    public void delete() throws IOException {
        this.initChain();
        this.parent.removeEntry(this.entry);
        this.parent.write();
        this.chain.setLength(0L);
    }

    @Override
    public boolean isRoot() {
        return false;
    }
}

