/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemFactory;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Partition
implements BlockDeviceDriver {
    private static final String TAG = Partition.class.getSimpleName();
    private BlockDeviceDriver blockDevice;
    private int logicalBlockAddress;
    private int blockSize;
    private FileSystem fileSystem;

    private Partition() {
    }

    public static Partition createPartition(PartitionTableEntry entry, BlockDeviceDriver blockDevice) throws IOException {
        Partition partition = null;
        byte partitionType = entry.getPartitionType();
        if (partitionType == 11 || partitionType == 12) {
            partition = new Partition();
            partition.logicalBlockAddress = entry.getLogicalBlockAddress();
            partition.blockDevice = blockDevice;
            partition.blockSize = blockDevice.getBlockSize();
            partition.fileSystem = FileSystemFactory.createFileSystem(entry, partition);
        } else {
            Log.w((String)TAG, (String)("unsupported partition type: " + entry.getPartitionType()));
        }
        return partition;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getVolumeLabel() {
        return this.fileSystem.getVolumeLabel();
    }

    @Override
    public void init() {
    }

    @Override
    public void read(long offset, ByteBuffer dest) throws IOException {
        long devOffset = offset / (long)this.blockSize + (long)this.logicalBlockAddress;
        if (offset % (long)this.blockSize != 0L) {
            Log.w((String)TAG, (String)"device offset not a multiple of block size");
            ByteBuffer tmp = ByteBuffer.allocate(this.blockSize);
            this.blockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(offset % (long)this.blockSize));
            dest.put(tmp);
            ++devOffset;
        }
        if (dest.remaining() > 0) {
            this.blockDevice.read(devOffset, dest);
        }
    }

    @Override
    public void write(long offset, ByteBuffer src) throws IOException {
        long devOffset = offset / (long)this.blockSize + (long)this.logicalBlockAddress;
        if (offset % (long)this.blockSize != 0L) {
            Log.w((String)TAG, (String)"device offset not a multiple of block size");
            ByteBuffer tmp = ByteBuffer.allocate(this.blockSize);
            this.blockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(offset % (long)this.blockSize));
            int remaining = Math.min(tmp.remaining(), src.remaining());
            tmp.put(src.array(), src.position(), remaining);
            src.position(src.position() + remaining);
            tmp.clear();
            this.blockDevice.write(devOffset, tmp);
            ++devOffset;
        }
        if (src.remaining() > 0) {
            this.blockDevice.write(devOffset, src);
        }
    }

    @Override
    public int getBlockSize() {
        return this.blockDevice.getBlockSize();
    }
}

