/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.http;

import com.ok2c.hc.android.http.ssl.AndroidSSLConnectionSocketFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class AndroidHttpClientConnectionManagerBuilder {
    private HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connectionFactory;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private SocketConfig defaultSocketConfig;
    private int maxConnTotal = 0;
    private int maxConnPerRoute = 0;
    private long timeToLive;
    private TimeUnit timeToLiveTimeUnit;

    public static AndroidHttpClientConnectionManagerBuilder create() {
        return new AndroidHttpClientConnectionManagerBuilder();
    }

    private AndroidHttpClientConnectionManagerBuilder() {
    }

    public final AndroidHttpClientConnectionManagerBuilder setConnectionFactory(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setSSLSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setMaxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setDefaultSocketConfig(SocketConfig config) {
        this.defaultSocketConfig = config;
        return this;
    }

    public final AndroidHttpClientConnectionManagerBuilder setConnectionTimeToLive(long timeToLive, TimeUnit timeToLiveTimeUnit) {
        this.timeToLive = timeToLive;
        this.timeToLiveTimeUnit = timeToLiveTimeUnit;
        return this;
    }

    public PoolingHttpClientConnectionManager build() {
        PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", this.sslSocketFactory != null ? this.sslSocketFactory : AndroidSSLConnectionSocketFactory.getSystemSocketFactory()).build(), this.connectionFactory, this.schemePortResolver, this.dnsResolver, this.timeToLive, this.timeToLiveTimeUnit != null ? this.timeToLiveTimeUnit : TimeUnit.MILLISECONDS);
        if (this.defaultSocketConfig != null) {
            poolingmgr.setDefaultSocketConfig(this.defaultSocketConfig);
        }
        if (this.maxConnTotal > 0) {
            poolingmgr.setMaxTotal(this.maxConnTotal);
        }
        if (this.maxConnPerRoute > 0) {
            poolingmgr.setDefaultMaxPerRoute(this.maxConnPerRoute);
        }
        return poolingmgr;
    }
}

