/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.http;

import java.util.Objects;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;

public final class ExecUpdate {
    private final State state;
    private final RequestLine requestLine;
    private final StatusLine statusLine;
    private final long current;
    private final long total;
    private final Exception exception;

    public static ExecUpdate request(RequestLine requestLine) {
        return new ExecUpdate(State.REQUEST, requestLine, null, 0L, -1L, null);
    }

    public static ExecUpdate response(RequestLine requestLine, StatusLine statusLine, long current, long total) {
        return new ExecUpdate(State.RESPONSE, requestLine, statusLine, current, total, null);
    }

    public static ExecUpdate error(RequestLine requestLine, Exception exception) {
        return new ExecUpdate(State.ERROR, requestLine, null, 0L, -1L, exception);
    }

    private ExecUpdate(State state, RequestLine requestLine, StatusLine statusLine, long current, long total, Exception exception) {
        this.state = state;
        this.requestLine = requestLine;
        this.statusLine = statusLine;
        this.current = current;
        this.total = total;
        this.exception = exception;
    }

    public State getState() {
        return this.state;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Exception getException() {
        return this.exception;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getTotal() {
        return this.total;
    }

    public String toString() {
        switch (this.state) {
            case REQUEST: {
                return "REQUEST " + this.requestLine;
            }
            case RESPONSE: {
                return "RESPONSE " + this.statusLine + " (" + this.current + " of " + this.total + ")";
            }
            case ERROR: {
                return "ERROR " + this.exception;
            }
        }
        return Objects.toString(this.requestLine);
    }

    static enum State {
        REQUEST,
        RESPONSE,
        ERROR;

    }
}

