/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.http;

import android.os.AsyncTask;
import com.ok2c.hc.android.http.ExecUpdate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class HttpExecAsyncTask<T>
extends AsyncTask<HttpUriRequest, ExecUpdate, List<T>> {
    private final CloseableHttpClient httpClient;
    private final ResponseHandler<T> responseHandler;

    public HttpExecAsyncTask(CloseableHttpClient httpClient, ResponseHandler<T> responseHandler) {
        this.httpClient = (CloseableHttpClient)Args.notNull((Object)httpClient, (String)"HttpClient");
        this.responseHandler = (ResponseHandler)Args.notNull(responseHandler, (String)"Response handler");
    }

    protected List<T> doInBackground(HttpUriRequest ... requests) {
        HttpClientContext context = HttpClientContext.create();
        ArrayList<T> results = new ArrayList<T>();
        for (HttpUriRequest request : requests) {
            final RequestLine requestLine = request.getRequestLine();
            this.publishProgress(new ExecUpdate[]{ExecUpdate.request(requestLine)});
            try (CloseableHttpResponse response = this.httpClient.execute(request, (HttpContext)context);){
                HttpEntity entity = response.getEntity();
                final StatusLine statusLine = response.getStatusLine();
                if (entity != null) {
                    final long total = entity.getContentLength();
                    try (final InputStream inputStream = entity.getContent();){
                        this.publishProgress(new ExecUpdate[]{ExecUpdate.response(requestLine, statusLine, 0L, total)});
                        ContentType contentType = ContentType.get((HttpEntity)entity);
                        results.add(this.responseHandler.handle((HttpRequest)request, (HttpResponse)response, contentType, new InputStream(){
                            long current = 0L;
                            long last = 0L;

                            void fireUpdate() {
                                long n = this.current / 2048L;
                                if (n > this.last) {
                                    this.last = n;
                                    HttpExecAsyncTask.this.publishProgress(new ExecUpdate[]{ExecUpdate.response(requestLine, statusLine, this.current, total)});
                                }
                            }

                            @Override
                            public int read() throws IOException {
                                int b = inputStream.read();
                                if (b != -1) {
                                    ++this.current;
                                    this.fireUpdate();
                                }
                                return b;
                            }

                            @Override
                            public int read(byte[] b) throws IOException {
                                int bytesRead = inputStream.read(b);
                                if (bytesRead > 0) {
                                    this.current += (long)bytesRead;
                                    this.fireUpdate();
                                }
                                return bytesRead;
                            }

                            @Override
                            public int read(byte[] b, int off, int len) throws IOException {
                                int bytesRead = inputStream.read(b, off, len);
                                if (bytesRead > 0) {
                                    this.current += (long)bytesRead;
                                    this.fireUpdate();
                                }
                                return bytesRead;
                            }

                            @Override
                            public long skip(long n) throws IOException {
                                long skipped = inputStream.skip(n);
                                if (skipped > 0L) {
                                    this.current += skipped;
                                }
                                return skipped;
                            }

                            @Override
                            public int available() throws IOException {
                                return inputStream.available();
                            }

                            @Override
                            public void close() throws IOException {
                                inputStream.close();
                            }
                        }));
                        continue;
                    }
                }
                this.publishProgress(new ExecUpdate[]{ExecUpdate.response(requestLine, statusLine, 0L, 0L)});
                results.add(this.responseHandler.handle((HttpRequest)request, (HttpResponse)response, null, null));
            }
            catch (IOException ex) {
                this.publishProgress(new ExecUpdate[]{ExecUpdate.error(requestLine, ex)});
                break;
            }
        }
        return results;
    }

    public static interface ResponseHandler<T> {
        public T handle(HttpRequest var1, HttpResponse var2, ContentType var3, InputStream var4) throws IOException;
    }
}

