/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.http.ssl;

import com.ok2c.hc.android.http.ssl.AndroidSSLConnectionSocketFactory;
import com.ok2c.hc.android.http.ssl.TLS;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class AndroidSSLConnectionSocketFactoryBuilder {
    private SSLContext sslContext;
    private String[] tlsVersions;
    private String[] ciphers;
    private HostnameVerifier hostnameVerifier;

    public static AndroidSSLConnectionSocketFactoryBuilder create() {
        return new AndroidSSLConnectionSocketFactoryBuilder();
    }

    public AndroidSSLConnectionSocketFactoryBuilder setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final AndroidSSLConnectionSocketFactoryBuilder setTlsVersions(String ... tlslVersions) {
        this.tlsVersions = tlslVersions;
        return this;
    }

    public final AndroidSSLConnectionSocketFactoryBuilder setTlsVersions(TLS ... tlslVersions) {
        this.tlsVersions = new String[tlslVersions.length];
        for (int i = 0; i < tlslVersions.length; ++i) {
            this.tlsVersions[i] = tlslVersions[i].ident;
        }
        return this;
    }

    public final AndroidSSLConnectionSocketFactoryBuilder setCiphers(String ... ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    public AndroidSSLConnectionSocketFactoryBuilder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public SSLConnectionSocketFactory build() {
        SSLSocketFactory socketfactory = this.sslContext != null ? this.sslContext.getSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return new SSLConnectionSocketFactory(socketfactory, this.tlsVersions, this.ciphers, this.hostnameVerifier != null ? this.hostnameVerifier : AndroidSSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }
}

