/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.logging;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class HttpClientLogHandler
extends Handler {
    private static final Formatter FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord r) {
            Throwable thrown = r.getThrown();
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                sw.write(r.getMessage());
                sw.write("\n");
                thrown.printStackTrace(pw);
                pw.flush();
                return sw.toString();
            }
            return r.getMessage();
        }
    };

    private static int getAndroidLevel(Level level) {
        int value = level.intValue();
        if (value >= 1000) {
            return 6;
        }
        if (value >= 900) {
            return 5;
        }
        if (value >= 800) {
            return 4;
        }
        return 3;
    }

    private static String loggerNameToTag(String loggerName) {
        if (loggerName == null) {
            return "null";
        }
        int length = loggerName.length();
        if (length <= 23) {
            return loggerName;
        }
        int lastPeriod = loggerName.lastIndexOf(".");
        return length - (lastPeriod + 1) <= 23 ? loggerName.substring(lastPeriod + 1) : loggerName.substring(loggerName.length() - 23);
    }

    public HttpClientLogHandler() {
        this.setFormatter(FORMATTER);
    }

    @Override
    public void publish(LogRecord record) {
        int level = HttpClientLogHandler.getAndroidLevel(record.getLevel());
        String loggerName = record.getLoggerName();
        String tag = loggerName.equals("org.apache.http.wire") ? "HttpClientWire" : (loggerName.equals("org.apache.http.headers") ? "HttpClientHeader" : (loggerName.startsWith("org.apache.http.") ? "HttpClient" : HttpClientLogHandler.loggerNameToTag(loggerName)));
        if (!Log.isLoggable((String)tag, (int)level)) {
            return;
        }
        try {
            String message = this.getFormatter().format(record);
            Log.println((int)level, (String)tag, (String)message);
        }
        catch (RuntimeException e) {
            Log.e((String)"HttpClientLogHandler", (String)"Error logging message.", (Throwable)e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

