/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.github.pedrovgs.lynx.LynxConfig;
import com.github.pedrovgs.lynx.LynxShakeDetector;
import com.github.pedrovgs.lynx.LynxView;
import com.github.pedrovgs.lynx.R;
import java.io.Serializable;

public class LynxActivity
extends Activity {
    private static final String LYNX_CONFIG_EXTRA = "extra_lynx_config";

    public static Intent getIntent(Context context, LynxConfig lynxConfig) {
        if (lynxConfig == null) {
            lynxConfig = new LynxConfig();
        }
        Intent intent = new Intent(context, LynxActivity.class);
        intent.putExtra(LYNX_CONFIG_EXTRA, (Serializable)lynxConfig);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.lynx_activity);
        LynxConfig lynxConfig = this.getLynxConfig();
        this.configureLynxView(lynxConfig);
        this.disableLynxShakeDetector();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.enableLynxShakeDetector();
    }

    private LynxConfig getLynxConfig() {
        Bundle extras = this.getIntent().getExtras();
        LynxConfig lynxConfig = new LynxConfig();
        if (extras != null) {
            lynxConfig = (LynxConfig)extras.getSerializable(LYNX_CONFIG_EXTRA);
        }
        return lynxConfig;
    }

    private void configureLynxView(LynxConfig lynxConfig) {
        LynxView lynxView = (LynxView)this.findViewById(R.id.lynx_view);
        lynxView.setLynxConfig(lynxConfig);
    }

    private void enableLynxShakeDetector() {
        LynxShakeDetector.enable();
    }

    private void disableLynxShakeDetector() {
        LynxShakeDetector.disable();
    }
}

