/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx;

import android.content.Context;
import android.content.Intent;
import android.hardware.SensorManager;
import com.github.pedrovgs.lynx.LynxActivity;
import com.squareup.seismic.ShakeDetector;

public class LynxShakeDetector {
    private final Context context;
    private static boolean isEnabled = true;

    public LynxShakeDetector(Context context) {
        this.context = context;
    }

    public void init() {
        ShakeDetector shakeDetector = new ShakeDetector(new ShakeDetector.Listener(){

            public void hearShake() {
                if (isEnabled) {
                    LynxShakeDetector.this.openLynxActivity();
                }
            }
        });
        SensorManager sensorManager = (SensorManager)this.context.getSystemService("sensor");
        shakeDetector.start(sensorManager);
    }

    static void enable() {
        isEnabled = true;
    }

    static void disable() {
        isEnabled = false;
    }

    private void openLynxActivity() {
        Intent lynxActivityIntent = new Intent(this.context, LynxActivity.class);
        lynxActivityIntent.setFlags(0x10000000);
        this.context.startActivity(lynxActivityIntent);
    }
}

