/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.github.pedrovgs.lynx.LynxConfig;
import com.github.pedrovgs.lynx.R;
import com.github.pedrovgs.lynx.model.AndroidMainThread;
import com.github.pedrovgs.lynx.model.Logcat;
import com.github.pedrovgs.lynx.model.Lynx;
import com.github.pedrovgs.lynx.model.TimeProvider;
import com.github.pedrovgs.lynx.model.Trace;
import com.github.pedrovgs.lynx.model.TraceLevel;
import com.github.pedrovgs.lynx.presenter.LynxPresenter;
import com.github.pedrovgs.lynx.renderer.TraceRendererBuilder;
import com.pedrogomez.renderers.AdapteeCollection;
import com.pedrogomez.renderers.ListAdapteeCollection;
import com.pedrogomez.renderers.RendererAdapter;
import com.pedrogomez.renderers.RendererBuilder;
import java.lang.reflect.Field;
import java.util.List;

public class LynxView
extends RelativeLayout
implements LynxPresenter.View {
    private static final String LOGTAG = "LynxView";
    private static final String SHARE_INTENT_TYPE = "text/plain";
    private static final CharSequence SHARE_INTENT_TITLE = "Application Logcat";
    private static final int DEFAULT_POSITION = 0;
    private LynxPresenter presenter;
    private LynxConfig lynxConfig;
    private ListView lv_traces;
    private EditText et_filter;
    private ImageButton ib_share;
    private Spinner sp_filter;
    private RendererAdapter<Trace> adapter;
    private int lastScrollPosition;

    public LynxView(Context context) {
        this(context, null);
    }

    public LynxView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LynxView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeConfiguration(attrs);
        this.initializePresenter();
        this.initializeView();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isVisible()) {
            this.resumePresenter();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.pausePresenter();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (changedView != this) {
            return;
        }
        if (visibility == 0) {
            this.resumePresenter();
        } else {
            this.pausePresenter();
        }
    }

    public void setLynxConfig(LynxConfig lynxConfig) {
        boolean hasChangedLynxConfig;
        this.validateLynxConfig(lynxConfig);
        boolean bl = hasChangedLynxConfig = !this.lynxConfig.equals(lynxConfig);
        if (hasChangedLynxConfig) {
            this.lynxConfig = (LynxConfig)lynxConfig.clone();
            this.updateFilterText();
            this.updateAdapter();
            this.presenter.setLynxConfig(lynxConfig);
        }
    }

    public LynxConfig getLynxConfig() {
        return this.lynxConfig;
    }

    @Override
    public void showTraces(List<Trace> traces, int removedTraces) {
        if (this.lastScrollPosition == 0) {
            this.lastScrollPosition = this.lv_traces.getFirstVisiblePosition();
        }
        this.adapter.clear();
        this.adapter.addAll(traces);
        this.adapter.notifyDataSetChanged();
        this.updateScrollPosition(removedTraces);
    }

    @Override
    public void clear() {
        this.adapter.clear();
        this.adapter.notifyDataSetChanged();
    }

    @Override
    public void shareTraces(String plainTraces) {
        Intent sharingIntent = new Intent("android.intent.action.SEND");
        sharingIntent.setType(SHARE_INTENT_TYPE);
        sharingIntent.putExtra("android.intent.extra.TEXT", plainTraces);
        this.getContext().startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)SHARE_INTENT_TITLE));
    }

    @Override
    public void disableAutoScroll() {
        this.lv_traces.setTranscriptMode(0);
    }

    @Override
    public void enableAutoScroll() {
        this.lv_traces.setTranscriptMode(2);
    }

    private boolean isPresenterReady() {
        return this.presenter != null;
    }

    private void resumePresenter() {
        if (this.isPresenterReady()) {
            this.presenter.resume();
            int lastPosition = this.adapter.getCount() - 1;
            this.lv_traces.setSelection(lastPosition);
        }
    }

    private void pausePresenter() {
        if (this.isPresenterReady()) {
            this.presenter.pause();
        }
    }

    private boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private void initializeConfiguration(AttributeSet attrs) {
        this.lynxConfig = new LynxConfig();
        if (attrs != null) {
            TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.lynx);
            int maxTracesToShow = attributes.getInteger(R.styleable.lynx_max_traces_to_show, this.lynxConfig.getMaxNumberOfTracesToShow());
            String filter = attributes.getString(R.styleable.lynx_filter);
            float fontSizeInPx = attributes.getDimension(R.styleable.lynx_text_size, -1.0f);
            if (fontSizeInPx != -1.0f) {
                fontSizeInPx = this.pixelsToSp(fontSizeInPx);
                this.lynxConfig.setTextSizeInPx(fontSizeInPx);
            }
            int samplingRate = attributes.getInteger(R.styleable.lynx_sampling_rate, this.lynxConfig.getSamplingRate());
            this.lynxConfig.setMaxNumberOfTracesToShow(maxTracesToShow).setFilter(TextUtils.isEmpty((CharSequence)filter) ? "" : filter).setSamplingRate(samplingRate);
            attributes.recycle();
        }
    }

    private void initializeView() {
        Context context = this.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.lynx_view, (ViewGroup)this);
        this.mapGui();
        this.initializeRenderers();
        this.hookListeners();
    }

    private void mapGui() {
        this.lv_traces = (ListView)this.findViewById(R.id.lv_traces);
        this.lv_traces.setTranscriptMode(2);
        this.et_filter = (EditText)this.findViewById(R.id.et_filter);
        this.ib_share = (ImageButton)this.findViewById(R.id.ib_share);
        this.sp_filter = (Spinner)this.findViewById(R.id.sp_filter);
        this.configureCursorColor();
        this.updateFilterText();
    }

    private void configureCursorColor() {
        try {
            Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
            f.setAccessible(true);
            f.set(this.et_filter, R.drawable.edit_text_cursor_color);
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)"Error trying to change cursor color text cursor drawable to null.");
        }
    }

    private void initializeRenderers() {
        TraceRendererBuilder tracesRendererBuilder = new TraceRendererBuilder(this.lynxConfig);
        Context context = this.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.adapter = new RendererAdapter(layoutInflater, (RendererBuilder)tracesRendererBuilder, (AdapteeCollection)new ListAdapteeCollection());
        this.adapter.addAll(this.presenter.getCurrentTraces());
        if (this.adapter.getCount() > 0) {
            this.adapter.notifyDataSetChanged();
        }
        this.lv_traces.setAdapter(this.adapter);
    }

    private void hookListeners() {
        this.lv_traces.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (LynxView.this.lastScrollPosition - firstVisibleItem != 1) {
                    LynxView.this.lastScrollPosition = firstVisibleItem;
                }
                int lastVisiblePositionInTheList = firstVisibleItem + visibleItemCount;
                LynxView.this.presenter.onScrollToPosition(lastVisiblePositionInTheList);
            }
        });
        this.et_filter.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                LynxView.this.presenter.updateFilter(s.toString());
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.ib_share.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LynxView.this.presenter.onShareButtonClicked();
            }
        });
        ArrayAdapter adapter = new ArrayAdapter(this.getContext(), R.layout.single_line_spinner_item, (Object[])TraceLevel.values());
        this.sp_filter.setAdapter((SpinnerAdapter)adapter);
        this.sp_filter.setSelection(0);
        this.sp_filter.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                LynxView.this.presenter.updateFilterTraceLevel((TraceLevel)((Object)parent.getItemAtPosition(position)));
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
    }

    private void initializePresenter() {
        Lynx lynx = new Lynx(new Logcat(), new AndroidMainThread(), new TimeProvider());
        lynx.setConfig(this.lynxConfig);
        this.presenter = new LynxPresenter(lynx, this, this.lynxConfig.getMaxNumberOfTracesToShow());
    }

    private void validateLynxConfig(LynxConfig lynxConfig) {
        if (lynxConfig == null) {
            throw new IllegalArgumentException("You can't configure Lynx with a null LynxConfig instance.");
        }
    }

    private void updateFilterText() {
        if (this.lynxConfig.hasFilter()) {
            this.et_filter.append((CharSequence)this.lynxConfig.getFilter());
        }
    }

    private void updateAdapter() {
        if (this.lynxConfig.hasTextSizeInPx() && this.lynxConfig.getTextSizeInPx() != this.lynxConfig.getTextSizeInPx()) {
            this.initializeRenderers();
        }
    }

    private float pixelsToSp(float px) {
        float scaledDensity = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return px / scaledDensity;
    }

    private void updateScrollPosition(int removedTraces) {
        boolean shouldUpdateScrollPosition;
        boolean bl = shouldUpdateScrollPosition = removedTraces > 0;
        if (shouldUpdateScrollPosition) {
            int newScrollPosition;
            this.lastScrollPosition = newScrollPosition = this.lastScrollPosition - removedTraces;
            this.lv_traces.setSelectionFromTop(newScrollPosition, 0);
        }
    }

    void setPresenter(LynxPresenter presenter) {
        this.presenter = presenter;
    }
}

