/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.presenter;

import com.github.pedrovgs.lynx.LynxConfig;
import com.github.pedrovgs.lynx.model.Lynx;
import com.github.pedrovgs.lynx.model.Trace;
import com.github.pedrovgs.lynx.model.TraceLevel;
import com.github.pedrovgs.lynx.presenter.TraceBuffer;
import java.util.LinkedList;
import java.util.List;

public class LynxPresenter
implements Lynx.Listener {
    private static final int MIN_VISIBLE_POSITION_TO_ENABLE_AUTO_SCROLL = 3;
    private final Lynx lynx;
    private final View view;
    private final TraceBuffer traceBuffer;
    private boolean isInitialized;

    public LynxPresenter(Lynx lynx, View view, int maxNumberOfTracesToShow) {
        this.validateNumberOfTracesConfiguration(maxNumberOfTracesToShow);
        this.lynx = lynx;
        this.view = view;
        this.traceBuffer = new TraceBuffer(maxNumberOfTracesToShow);
    }

    public void setLynxConfig(LynxConfig lynxConfig) {
        this.validateLynxConfig(lynxConfig);
        this.updateBufferConfig(lynxConfig);
        this.updateLynxConfig(lynxConfig);
    }

    public void resume() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.lynx.registerListener(this);
            this.lynx.startReading();
        }
    }

    public void pause() {
        if (this.isInitialized) {
            this.isInitialized = false;
            this.lynx.stopReading();
            this.lynx.unregisterListener(this);
        }
    }

    @Override
    public void onNewTraces(List<Trace> traces) {
        int tracesRemoved = this.updateTraceBuffer(traces);
        List<Trace> tracesToNotify = this.getCurrentTraces();
        this.view.showTraces(tracesToNotify, tracesRemoved);
    }

    public void updateFilter(String filter) {
        if (this.isInitialized) {
            LynxConfig lynxConfig = this.lynx.getConfig();
            lynxConfig.setFilter(filter);
            this.lynx.setConfig(lynxConfig);
            this.clearView();
            this.restartLynx();
        }
    }

    public void updateFilterTraceLevel(TraceLevel level) {
        if (this.isInitialized) {
            LynxConfig lynxConfig = this.lynx.getConfig();
            lynxConfig.setFilterTraceLevel(level);
            this.lynx.setConfig(lynxConfig);
            this.clearView();
            this.restartLynx();
        }
    }

    public void onShareButtonClicked() {
        LinkedList<Trace> tracesToShare = new LinkedList<Trace>(this.traceBuffer.getTraces());
        String plainTraces = this.generatePlainTracesToShare(tracesToShare);
        this.view.shareTraces(plainTraces);
    }

    public void onScrollToPosition(int lastVisiblePositionInTheList) {
        if (this.shouldDisableAutoScroll(lastVisiblePositionInTheList)) {
            this.view.disableAutoScroll();
        } else {
            this.view.enableAutoScroll();
        }
    }

    public List<Trace> getCurrentTraces() {
        return this.traceBuffer.getTraces();
    }

    private void clearView() {
        this.traceBuffer.clear();
        this.view.clear();
    }

    private void restartLynx() {
        this.lynx.restart();
    }

    private void updateBufferConfig(LynxConfig lynxConfig) {
        this.traceBuffer.setBufferSize(lynxConfig.getMaxNumberOfTracesToShow());
        this.refreshTraces();
    }

    private void refreshTraces() {
        this.onNewTraces(this.traceBuffer.getTraces());
    }

    private void updateLynxConfig(LynxConfig lynxConfig) {
        this.lynx.setConfig(lynxConfig);
    }

    private int updateTraceBuffer(List<Trace> traces) {
        return this.traceBuffer.add(traces);
    }

    private void validateNumberOfTracesConfiguration(long maxNumberOfTracesToShow) {
        if (maxNumberOfTracesToShow <= 0L) {
            throw new IllegalArgumentException("You can't pass a zero or negative number of traces to show.");
        }
    }

    private void validateLynxConfig(LynxConfig lynxConfig) {
        if (lynxConfig == null) {
            throw new IllegalArgumentException("You can't use a null instance of LynxConfig as configuration.");
        }
    }

    private boolean shouldDisableAutoScroll(int lastVisiblePosition) {
        int positionOffset = this.traceBuffer.getCurrentNumberOfTraces() - lastVisiblePosition;
        return positionOffset >= 3;
    }

    private String generatePlainTracesToShare(List<Trace> tracesToShare) {
        StringBuilder sb = new StringBuilder();
        for (Trace trace : tracesToShare) {
            String traceLevel = trace.getLevel().getValue();
            String traceMessage = trace.getMessage();
            sb.append(traceLevel);
            sb.append("/ ");
            sb.append(traceMessage);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface View {
        public void showTraces(List<Trace> var1, int var2);

        public void clear();

        public void shareTraces(String var1);

        public void disableAutoScroll();

        public void enableAutoScroll();
    }
}

