/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.renderer;

import android.graphics.Typeface;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.github.pedrovgs.lynx.LynxConfig;
import com.github.pedrovgs.lynx.R;
import com.github.pedrovgs.lynx.model.Trace;
import com.github.pedrovgs.lynx.model.TraceLevel;
import com.pedrogomez.renderers.Renderer;

class TraceRenderer
extends Renderer<Trace> {
    private final LynxConfig lynxConfig;
    private TextView tv_trace;

    TraceRenderer(LynxConfig lynxConfig) {
        this.lynxConfig = lynxConfig;
    }

    protected View inflate(LayoutInflater inflater, ViewGroup parent) {
        return inflater.inflate(R.layout.trace_row, parent, false);
    }

    protected void setUpView(View rootView) {
        this.tv_trace = (TextView)rootView.findViewById(R.id.tv_trace);
        this.tv_trace.setTypeface(Typeface.MONOSPACE);
        if (this.lynxConfig.hasTextSizeInPx()) {
            float textSize = this.lynxConfig.getTextSizeInPx();
            this.tv_trace.setTextSize(textSize);
        }
    }

    protected void hookListeners(View rootView) {
    }

    public void render() {
        Trace trace = (Trace)this.getContent();
        String traceMessage = trace.getMessage();
        Spannable traceRepresentation = this.getTraceVisualRepresentation(trace.getLevel(), traceMessage);
        this.tv_trace.setText((CharSequence)traceRepresentation);
    }

    protected int getTraceColor() {
        return -7829368;
    }

    private Spannable getTraceVisualRepresentation(TraceLevel level, String traceMessage) {
        traceMessage = " " + level.getValue() + "  " + traceMessage;
        SpannableString traceRepresentation = new SpannableString((CharSequence)traceMessage);
        int traceColor = this.getTraceColor();
        traceRepresentation.setSpan((Object)new BackgroundColorSpan(traceColor), 0, 3, 33);
        return traceRepresentation;
    }
}

