/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.filter;

import com.power.common.filter.AbstractUrlMatcher;
import com.power.common.filter.XssHttpServletRequestWrapper;
import com.power.common.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XssAndSqlFilter
extends AbstractUrlMatcher
implements Filter {
    public static final String IGNORES = "ignores";
    FilterConfig filterConfig = null;
    private Set<String> excluded = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String excludedString = filterConfig.getInitParameter(IGNORES);
        this.excluded = StringUtil.isNotEmpty(excludedString) ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(excludedString.split(";", 0)))) : Collections.emptySet();
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        HttpServletRequest req = (HttpServletRequest)request;
        res.addHeader("X-XSS-Protection", "1; mode=block");
        res.addHeader("X-Content-Type-Options", "nosniff");
        if (this.isExcluded(req)) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request), response);
        }
    }

    private boolean isExcluded(HttpServletRequest request) {
        String url0 = request.getRequestURI();
        return this.isMatches(this.excluded, url0);
    }
}

