/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StringEscapeUtil {
    public static final Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_ESCAPE;
    private static final Map<String, String> lookupMap;

    public static String escapeJava(String content) {
        return StringEscapeUtil.escapeJava(content, Boolean.FALSE);
    }

    public static String escapeJavaIgnoreChinese(String content) {
        return StringEscapeUtil.escapeJava(content, Boolean.TRUE);
    }

    public static String escapeJava(String content, Boolean ignoreChinese) {
        if (Objects.isNull(content)) {
            return null;
        }
        StringBuilder tmp = new StringBuilder(content.length() * 6);
        for (int i = 0; i < content.length(); ++i) {
            char j = content.charAt(i);
            String index = Integer.toHexString(j);
            if (lookupMap.containsKey(index)) {
                tmp.append(lookupMap.get(index));
                continue;
            }
            if (j >= '\u4e00' && j <= '\u9fbb' && ignoreChinese.booleanValue()) {
                tmp.append(j);
                continue;
            }
            if (j >= ' ' && j <= '\u00f7') {
                tmp.append(j);
                continue;
            }
            tmp.append("\\u");
            tmp.append(Character.toUpperCase(Character.forDigit(j >>> 12 & 0xF, 16)));
            tmp.append(Character.toUpperCase(Character.forDigit(j >>> 8 & 0xF, 16)));
            tmp.append(Character.toUpperCase(Character.forDigit(j >>> 4 & 0xF, 16)));
            tmp.append(Character.toUpperCase(Character.forDigit(j & 0xF, 16)));
        }
        return tmp.toString();
    }

    static {
        lookupMap = new HashMap<String, String>();
        HashMap<String, String> initialMap = new HashMap<String, String>();
        initialMap.put("\b", "\\b");
        initialMap.put("\n", "\\n");
        initialMap.put("\t", "\\t");
        initialMap.put("\f", "\\f");
        initialMap.put("\r", "\\r");
        initialMap.put("\"", "\\\"");
        initialMap.put("\\", "\\\\");
        JAVA_CTRL_CHARS_ESCAPE = Collections.unmodifiableMap(initialMap);
        for (Map.Entry<CharSequence, CharSequence> pair : JAVA_CTRL_CHARS_ESCAPE.entrySet()) {
            char c = pair.getKey().charAt(0);
            String index = Integer.toHexString(c);
            lookupMap.put(index, pair.getValue().toString());
        }
    }
}

