/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac3Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac4Extractor;
import com.google.android.exoplayer2.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer2.extractor.ts.TsExtractor;
import com.google.android.exoplayer2.source.hls.HlsMediaChunkExtractor;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.io.IOException;

public final class BundledHlsMediaChunkExtractor
implements HlsMediaChunkExtractor {
    private static final PositionHolder POSITION_HOLDER = new PositionHolder();
    @VisibleForTesting
    final Extractor extractor;
    private final Format masterPlaylistFormat;
    private final TimestampAdjuster timestampAdjuster;

    public BundledHlsMediaChunkExtractor(Extractor extractor, Format masterPlaylistFormat, TimestampAdjuster timestampAdjuster) {
        this.extractor = extractor;
        this.masterPlaylistFormat = masterPlaylistFormat;
        this.timestampAdjuster = timestampAdjuster;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractor.init(extractorOutput);
    }

    @Override
    public boolean read(ExtractorInput extractorInput) throws IOException {
        return this.extractor.read(extractorInput, POSITION_HOLDER) == 0;
    }

    @Override
    public boolean isPackedAudioExtractor() {
        return this.extractor instanceof AdtsExtractor || this.extractor instanceof Ac3Extractor || this.extractor instanceof Ac4Extractor || this.extractor instanceof Mp3Extractor;
    }

    @Override
    public boolean isReusable() {
        return this.extractor instanceof TsExtractor || this.extractor instanceof FragmentedMp4Extractor;
    }

    @Override
    public HlsMediaChunkExtractor recreate() {
        Object newExtractorInstance;
        Assertions.checkState((!this.isReusable() ? 1 : 0) != 0);
        if (this.extractor instanceof WebvttExtractor) {
            newExtractorInstance = new WebvttExtractor(this.masterPlaylistFormat.language, this.timestampAdjuster);
        } else if (this.extractor instanceof AdtsExtractor) {
            newExtractorInstance = new AdtsExtractor();
        } else if (this.extractor instanceof Ac3Extractor) {
            newExtractorInstance = new Ac3Extractor();
        } else if (this.extractor instanceof Ac4Extractor) {
            newExtractorInstance = new Ac4Extractor();
        } else if (this.extractor instanceof Mp3Extractor) {
            newExtractorInstance = new Mp3Extractor();
        } else {
            String string = String.valueOf(this.extractor.getClass().getSimpleName());
            throw new IllegalStateException(string.length() != 0 ? "Unexpected extractor type for recreation: ".concat(string) : new String("Unexpected extractor type for recreation: "));
        }
        return new BundledHlsMediaChunkExtractor((Extractor)newExtractorInstance, this.masterPlaylistFormat, this.timestampAdjuster);
    }

    @Override
    public void onTruncatedSegmentParsed() {
        this.extractor.seek(0L, 0L);
    }
}

