/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzbfy;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzxb;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzbfy {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzlq;
    private InterstitialAd zzlr;
    private AdLoader zzls;
    private Context zzlt;
    private InterstitialAd zzlu;
    private MediationRewardedVideoAdListener zzlv;
    @VisibleForTesting
    private final RewardedVideoAdListener zzlw = new com.google.ads.mediation.zza(this);

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzve.zzou();
            builder.addTestDevice(zzayk.zzbi(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzlq != null) {
            this.zzlq.destroy();
            this.zzlq = null;
        }
        if (this.zzlr != null) {
            this.zzlr = null;
        }
        if (this.zzls != null) {
            this.zzls = null;
        }
        if (this.zzlu != null) {
            this.zzlu = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzlq != null) {
            this.zzlq.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzlq != null) {
            this.zzlq.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzlq = new AdView(context);
        this.zzlq.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzlq.setAdUnitId(this.getAdUnitId(bundle));
        this.zzlq.setAdListener(new zze(this, mediationBannerListener));
        this.zzlq.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzlq;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzlr = new InterstitialAd(context);
        this.zzlr.setAdUnitId(this.getAdUnitId(bundle));
        this.zzlr.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzlr.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzlr != null) {
            this.zzlr.setImmersiveMode(bl);
        }
        if (this.zzlu != null) {
            this.zzlu.setImmersiveMode(bl);
        }
    }

    @Override
    public zzxb getVideoController() {
        VideoController videoController;
        if (this.zzlq != null && (videoController = this.zzlq.getVideoController()) != null) {
            return videoController.zzdl();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzlr.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzdf(1).zzaby();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zzf zzf2 = new zzf(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zzf2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isUnifiedNativeAdRequested()) {
            builder.forUnifiedNativeAd(zzf2);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zzf2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zzf2);
        }
        if (nativeMediationAdRequest.zzsz()) {
            for (String string2 : nativeMediationAdRequest.zzta().keySet()) {
                builder.forCustomTemplateAd(string2, zzf2, nativeMediationAdRequest.zzta().get(string2) != false ? zzf2 : null);
            }
        }
        this.zzls = builder.build();
        this.zzls.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzlt = context.getApplicationContext();
        this.zzlv = mediationRewardedVideoAdListener;
        this.zzlv.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzlt == null || this.zzlv == null) {
            zzayu.zzex("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzlu = new InterstitialAd(this.zzlt);
        this.zzlu.zzd(true);
        this.zzlu.setAdUnitId(this.getAdUnitId(bundle));
        this.zzlu.setRewardedVideoAdListener(this.zzlw);
        this.zzlu.setAdMetadataListener(new com.google.ads.mediation.zzb(this));
        this.zzlu.loadAd(this.zza(this.zzlt, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzlu.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzlv != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzlv;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzlu = null;
        return null;
    }

    static /* synthetic */ InterstitialAd zzb(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzlu;
    }

    static final class zzc
    extends NativeContentAdMapper {
        private final NativeContentAd zzlz;

        public zzc(NativeContentAd nativeContentAd) {
            this.zzlz = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzlz);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzbkd.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzlz);
            }
        }
    }

    static final class zzb
    extends UnifiedNativeAdMapper {
        private final UnifiedNativeAd zzly;

        public zzb(UnifiedNativeAd unifiedNativeAd) {
            this.zzly = unifiedNativeAd;
            this.setHeadline(unifiedNativeAd.getHeadline());
            this.setImages(unifiedNativeAd.getImages());
            this.setBody(unifiedNativeAd.getBody());
            this.setIcon(unifiedNativeAd.getIcon());
            this.setCallToAction(unifiedNativeAd.getCallToAction());
            this.setAdvertiser(unifiedNativeAd.getAdvertiser());
            this.setStarRating(unifiedNativeAd.getStarRating());
            this.setStore(unifiedNativeAd.getStore());
            this.setPrice(unifiedNativeAd.getPrice());
            this.zzn(unifiedNativeAd.zzjo());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(unifiedNativeAd.getVideoController());
        }

        @Override
        public final void trackViews(View view, Map<String, View> map, Map<String, View> map2) {
            if (view instanceof UnifiedNativeAdView) {
                ((UnifiedNativeAdView)view).setNativeAd(this.zzly);
                return;
            }
            NativeAdViewHolder nativeAdViewHolder = NativeAdViewHolder.zzbkd.get(view);
            if (nativeAdViewHolder != null) {
                nativeAdViewHolder.setNativeAd(this.zzly);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzlx;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzlx = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzlx);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzbkd.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzlx);
            }
        }
    }

    @VisibleForTesting
    static final class zzf
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener,
    UnifiedNativeAd.OnUnifiedNativeAdLoadedListener {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzma;
        @VisibleForTesting
        private final MediationNativeListener zzmd;

        public zzf(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzma = abstractAdViewAdapter;
            this.zzmd = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmd.onAdFailedToLoad(this.zzma, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmd.onAdOpened(this.zzma);
        }

        @Override
        public final void onAdClosed() {
            this.zzmd.onAdClosed(this.zzma);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmd.onAdLeftApplication(this.zzma);
        }

        @Override
        public final void onAdClicked() {
            this.zzmd.onAdClicked(this.zzma);
        }

        @Override
        public final void onAdImpression() {
            this.zzmd.onAdImpression(this.zzma);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzmd.onAdLoaded((MediationNativeAdapter)this.zzma, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
            this.zzmd.onAdLoaded((MediationNativeAdapter)this.zzma, new zzb(unifiedNativeAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzmd.onAdLoaded((MediationNativeAdapter)this.zzma, new zzc(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzmd.zza(this.zzma, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzmd.zza(this.zzma, nativeCustomTemplateAd, string);
        }
    }

    @VisibleForTesting
    static final class zzd
    extends AdListener
    implements zzty {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzma;
        @VisibleForTesting
        private final MediationInterstitialListener zzmb;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzma = abstractAdViewAdapter;
            this.zzmb = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmb.onAdLoaded(this.zzma);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmb.onAdFailedToLoad(this.zzma, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmb.onAdOpened(this.zzma);
        }

        @Override
        public final void onAdClosed() {
            this.zzmb.onAdClosed(this.zzma);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmb.onAdLeftApplication(this.zzma);
        }

        @Override
        public final void onAdClicked() {
            this.zzmb.onAdClicked(this.zzma);
        }
    }

    @VisibleForTesting
    static final class zze
    extends AdListener
    implements AppEventListener,
    zzty {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzma;
        @VisibleForTesting
        private final MediationBannerListener zzmc;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzma = abstractAdViewAdapter;
            this.zzmc = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmc.onAdLoaded(this.zzma);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmc.onAdFailedToLoad(this.zzma, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmc.onAdOpened(this.zzma);
        }

        @Override
        public final void onAdClosed() {
            this.zzmc.onAdClosed(this.zzma);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmc.onAdLeftApplication(this.zzma);
        }

        @Override
        public final void onAdClicked() {
            this.zzmc.onAdClicked(this.zzma);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzmc.zza(this.zzma, string, string2);
        }
    }
}

