/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaby;
import com.google.android.gms.internal.ads.zzael;
import com.google.android.gms.internal.ads.zzaen;
import com.google.android.gms.internal.ads.zzaeo;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzakz;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzuh;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzvm;
import com.google.android.gms.internal.ads.zzvn;
import com.google.android.gms.internal.ads.zzxj;

public class AdLoader {
    private final zzuh zzaba;
    private final Context zzup;
    private final zzvm zzabb;

    AdLoader(Context context, zzvm zzvm2) {
        this(context, zzvm2, zzuh.zzccn);
    }

    private AdLoader(Context context, zzvm zzvm2, zzuh zzuh2) {
        this.zzup = context;
        this.zzabb = zzvm2;
        this.zzaba = zzuh2;
    }

    private final void zza(zzxj zzxj2) {
        try {
            this.zzabb.zzb(zzuh.zza(this.zzup, zzxj2));
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzdg());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzxj zzxj2 = adRequest.zzdg();
        AdLoader adLoader = this;
        try {
            adLoader.zzabb.zza(zzuh.zza(adLoader.zzup, zzxj2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzdg());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzabb.zzka();
        }
        catch (RemoteException remoteException) {
            zzayu.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzabb.isLoading();
        }
        catch (RemoteException remoteException) {
            zzayu.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zzup;
        private final zzvn zzabd;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzve.zzov().zzb(context, string, new zzakz()));
        }

        private Builder(Context context, zzvn zzvn2) {
            this.zzup = context;
            this.zzabd = zzvn2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzabd.zza(new zzaeo(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzabd.zza(new zzael(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzabd.zza(new zzaer(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzabd.zza(string, new zzaeq(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzaen(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzuj zzuj2 = new zzuj(this.zzup, adSizeArray);
                this.zzabd.zza(new zzaep(onPublisherAdViewLoadedListener), zzuj2);
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzabd.zzb(new zzuc(adListener));
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzabd.zza(new zzaby(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzabd.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        @Deprecated
        @KeepForSdk
        public Builder withCorrelator(@NonNull Correlator correlator) {
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zzup, this.zzabd.zzpd());
            }
            catch (RemoteException remoteException) {
                zzayu.zzc("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

