/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import com.google.android.gms.ads.zzc;
import com.google.android.gms.internal.ads.zzayu;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class RequestConfiguration {
    private final int zzabo;
    private final int zzabp;
    private final String zzabq;
    private final List<String> zzabr;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_UNSPECIFIED = -1;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_FALSE = 0;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    public static final String MAX_AD_CONTENT_RATING_UNSPECIFIED = "";
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final List<String> zzabs = Arrays.asList("MA", "T", "PG", "G");

    private RequestConfiguration(int n, int n2, String string, List<String> list) {
        this.zzabo = n;
        this.zzabp = n2;
        this.zzabq = string;
        this.zzabr = list;
    }

    public int getTagForChildDirectedTreatment() {
        return this.zzabo;
    }

    public int getTagForUnderAgeOfConsent() {
        return this.zzabp;
    }

    public String getMaxAdContentRating() {
        if (this.zzabq == null) {
            return MAX_AD_CONTENT_RATING_UNSPECIFIED;
        }
        return this.zzabq;
    }

    public List<String> getTestDeviceIds() {
        return new ArrayList<String>(this.zzabr);
    }

    public Builder toBuilder() {
        return new Builder().setTagForChildDirectedTreatment(this.zzabo).setTagForUnderAgeOfConsent(this.zzabp).setMaxAdContentRating(this.zzabq).setTestDeviceIds(this.zzabr);
    }

    /* synthetic */ RequestConfiguration(int n, int n2, String string, List list, zzc zzc2) {
        this(n, n2, string, list);
    }

    public static class Builder {
        private int zzabo = -1;
        private int zzabp = -1;
        private String zzabq = null;
        private final List<String> zzabr = new ArrayList<String>();

        public RequestConfiguration build() {
            return new RequestConfiguration(this.zzabo, this.zzabp, this.zzabq, this.zzabr, null);
        }

        public Builder setTagForChildDirectedTreatment(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzabo = n;
            } else {
                zzayu.zzez(new StringBuilder(68).append("Invalid value passed to setTagForChildDirectedTreatment: ").append(n).toString());
            }
            return this;
        }

        public Builder setTagForUnderAgeOfConsent(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzabp = n;
            } else {
                zzayu.zzez(new StringBuilder(63).append("Invalid value passed to setTagForUnderAgeOfConsent: ").append(n).toString());
            }
            return this;
        }

        public Builder setMaxAdContentRating(String string) {
            if (string == null || RequestConfiguration.MAX_AD_CONTENT_RATING_UNSPECIFIED.equals(string)) {
                this.zzabq = null;
            } else if (RequestConfiguration.MAX_AD_CONTENT_RATING_G.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_PG.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_T.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_MA.equals(string)) {
                this.zzabq = string;
            } else {
                String string2 = String.valueOf(string);
                zzayu.zzez(string2.length() != 0 ? "Invalid value passed to setMaxAdContentRating: ".concat(string2) : new String("Invalid value passed to setMaxAdContentRating: "));
            }
            return this;
        }

        public Builder setTestDeviceIds(@Nullable List<String> list) {
            this.zzabr.clear();
            if (list != null) {
                this.zzabr.addAll(list);
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForChildDirectedTreatment {
    }
}

