/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.appopen;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.google.android.gms.ads.appopen.AppOpenAdPresentationCallback;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzrc;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzvu;

public final class AppOpenAdView
extends ViewGroup {
    private AppOpenAd zzaby;
    private AppOpenAdPresentationCallback zzabz;

    public AppOpenAdView(Context context) {
        super(context);
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null");
    }

    public AppOpenAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public AppOpenAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public final void setAppOpenAd(AppOpenAd appOpenAd) {
        try {
            zzvu zzvu2 = appOpenAd.zzdm();
            if (zzvu2 == null) {
                return;
            }
            IObjectWrapper iObjectWrapper = zzvu2.zzjx();
            if (iObjectWrapper == null) {
                return;
            }
            View view = (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            if (view.getParent() == null) {
                this.removeAllViews();
                this.addView(view);
                this.zzaby = appOpenAd;
                this.zzdo();
                return;
            }
            zzayu.zzex("Trying to set AppOpenAd which is already in use.");
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAppOpenAdPresentationCallback(AppOpenAdPresentationCallback appOpenAdPresentationCallback) {
        this.zzabz = appOpenAdPresentationCallback;
        this.zzdo();
    }

    private final void zzdo() {
        if (this.zzaby != null && this.zzabz != null) {
            this.zzaby.zza(new zzrc(this.zzabz));
        }
    }

    private final AdSize getAdSize() {
        zzvu zzvu2 = this.zzaby.zzdm();
        try {
            zzuj zzuj2;
            if (zzvu2 != null && (zzuj2 = zzvu2.zzjz()) != null) {
                return zzuj2.zzoo();
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzayu.zzc("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

