/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.query.AdData;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzxj;
import com.google.android.gms.internal.ads.zzxm;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzxj zzabc;

    private PublisherAdRequest(Builder builder) {
        this.zzabc = new zzxj(builder.zzabe);
    }

    @Deprecated
    public final Date getBirthday() {
        return this.zzabc.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzabc.getContentUrl();
    }

    @Deprecated
    public final int getGender() {
        return this.zzabc.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzabc.getKeywords();
    }

    public final Location getLocation() {
        return this.zzabc.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzabc.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzabc.getNetworkExtras(clazz);
    }

    public final <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzabc.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzabc.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzabc.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzabc.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzabc.getCustomTargeting();
    }

    @Deprecated
    @KeepForSdk
    public static void updateCorrelator() {
    }

    public final zzxj zzdg() {
        return this.zzabc;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @VisibleForTesting
    public static final class Builder {
        private final zzxm zzabe = new zzxm();

        public final Builder addKeyword(String string) {
            this.zzabe.zzcf(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzabe.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationExtrasReceiver> clazz, Bundle bundle) {
            this.zzabe.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzabe.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzabe.zzcg(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        @Deprecated
        public final Builder setBirthday(Date date) {
            this.zzabe.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            Preconditions.checkArgument((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzabe.zzci(string);
            return this;
        }

        @Deprecated
        public final Builder setGender(int n) {
            this.zzabe.zzcl(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzabe.zza(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzabe.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzabe.zzcj(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzabe.zzck(string);
            return this;
        }

        @Deprecated
        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzabe.zzz(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzabe.zze(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzabe.zze(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzabe.zzcl(string);
            return this;
        }

        @KeepForSdk
        public final Builder setAdData(AdData adData) {
            this.zzabe.zza(adData);
            return this;
        }

        @Deprecated
        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzabe.zzaa(bl);
            return this;
        }

        @Deprecated
        public final Builder setTagForUnderAgeOfConsent(int n) {
            this.zzabe.zzcm(n);
            return this;
        }

        @Deprecated
        public final Builder setMaxAdContentRating(String string) {
            this.zzabe.zzcm(string);
            return this;
        }
    }
}

