/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacp;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzve;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzacp zzbkc;
    public static WeakHashMap<View, NativeAdViewHolder> zzbkd = new WeakHashMap();
    private WeakReference<View> zzbke;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView || view instanceof UnifiedNativeAdView) {
            zzayu.zzex("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zzbkd.get(view) != null) {
            zzayu.zzex("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzbkd.put(view, this);
        this.zzbke = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzb(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzb(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzbkc = zzve.zzov().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzb(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        this.zza((IObjectWrapper)nativeAd.zzjj());
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        this.zza((IObjectWrapper)unifiedNativeAd.zzjj());
    }

    private final void zza(IObjectWrapper iObjectWrapper) {
        View view = this.zzbke != null ? (View)this.zzbke.get() : null;
        if (view == null) {
            zzayu.zzez("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzbkd.containsKey(view)) {
            zzbkd.put(view, this);
        }
        if (this.zzbkc != null) {
            try {
                this.zzbkc.zza(iObjectWrapper);
                return;
            }
            catch (RemoteException remoteException) {
                zzayu.zzc("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzbkc != null) {
            try {
                this.zzbkc.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzayu.zzc("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzbke != null ? (View)this.zzbke.get() : null) != null) {
            zzbkd.remove(view);
        }
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzbkc.zze(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }
}

