/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.zzd;
import com.google.android.gms.ads.formats.zze;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacd;
import com.google.android.gms.internal.ads.zzacm;
import com.google.android.gms.internal.ads.zzaek;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzzc;
import com.google.android.gms.internal.ads.zzzn;

public final class UnifiedNativeAdView
extends FrameLayout {
    private final FrameLayout zzbkf;
    private final zzacm zzbkg;

    public UnifiedNativeAdView(Context context) {
        super(context);
        this.zzbkf = this.zzd(context);
        this.zzbkg = this.zzjl();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbkf = this.zzd(context);
        this.zzbkg = this.zzjl();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbkf = this.zzd(context);
        this.zzbkg = this.zzjl();
    }

    @TargetApi(value=21)
    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzbkf = this.zzd(context);
        this.zzbkg = this.zzjl();
    }

    private final void zza(String string, View view) {
        try {
            this.zzbkg.zzb(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    public final void setHeadlineView(View view) {
        this.zza("3001", view);
    }

    public final void setCallToActionView(View view) {
        this.zza("3002", view);
    }

    public final void setIconView(View view) {
        this.zza("3003", view);
    }

    public final void setBodyView(View view) {
        this.zza("3004", view);
    }

    public final void setAdvertiserView(View view) {
        this.zza("3005", view);
    }

    public final void setStoreView(View view) {
        this.zza("3006", view);
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzbkg.zze(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    public final void setPriceView(View view) {
        this.zza("3007", view);
    }

    public final void setImageView(View view) {
        this.zza("3008", view);
    }

    public final void setStarRatingView(View view) {
        this.zza("3009", view);
    }

    public final void setMediaView(MediaView mediaView) {
        this.zza("3010", (View)mediaView);
        if (mediaView != null) {
            mediaView.zza(new zze(this));
            mediaView.zza(new zzd(this));
        }
    }

    public final void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("3011", (View)adChoicesView);
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        try {
            this.zzbkg.zza((IObjectWrapper)unifiedNativeAd.zzjj());
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    private final View zzbp(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzbkg.zzco(string);
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public final View getHeadlineView() {
        return this.zzbp("3001");
    }

    public final View getCallToActionView() {
        return this.zzbp("3002");
    }

    public final View getIconView() {
        return this.zzbp("3003");
    }

    public final View getBodyView() {
        return this.zzbp("3004");
    }

    public final View getStoreView() {
        return this.zzbp("3006");
    }

    public final View getPriceView() {
        return this.zzbp("3007");
    }

    public final View getAdvertiserView() {
        return this.zzbp("3005");
    }

    public final View getImageView() {
        return this.zzbp("3008");
    }

    public final View getStarRatingView() {
        return this.zzbp("3009");
    }

    public final MediaView getMediaView() {
        View view = this.zzbp("3010");
        if (view instanceof MediaView) {
            return (MediaView)view;
        }
        if (view != null) {
            zzayu.zzea("View is not an instance of MediaView");
        }
        return null;
    }

    public final AdChoicesView getAdChoicesView() {
        View view = this.zzbp("3011");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    public final void destroy() {
        try {
            this.zzbkg.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzd(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzacm zzjl() {
        Preconditions.checkNotNull((Object)this.zzbkf, (Object)"createDelegate must be called after overlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzve.zzov().zza(this.zzbkf.getContext(), this, this.zzbkf);
    }

    public final void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzbkf);
    }

    public final void removeView(View view) {
        if (this.zzbkf == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzbkf);
    }

    public final void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzbkf != view) {
            super.bringChildToFront((View)this.zzbkf);
        }
    }

    public final void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzbkg != null) {
            try {
                this.zzbkg.zzc(ObjectWrapper.wrap((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzayu.zzc("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }

    public final boolean dispatchTouchEvent(MotionEvent motionEvent) {
        zzzc<Boolean> zzzc2 = zzzn.zzclq;
        if (zzve.zzoy().zzd(zzzc2).booleanValue() && this.zzbkg != null) {
            try {
                this.zzbkg.zzf(ObjectWrapper.wrap((Object)motionEvent));
            }
            catch (RemoteException remoteException) {
                zzayu.zzc("Unable to call handleTouchEvent on delegate", remoteException);
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    final /* synthetic */ void zza(ImageView.ScaleType scaleType) {
        try {
            if (scaleType instanceof ImageView.ScaleType) {
                this.zzbkg.zzg(ObjectWrapper.wrap((Object)scaleType));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call setMediaViewImageScaleType on delegate", remoteException);
            return;
        }
    }

    final /* synthetic */ void zza(UnifiedNativeAd.MediaContent mediaContent) {
        try {
            if (mediaContent instanceof zzaek) {
                this.zzbkg.zza(((zzaek)mediaContent).zzrr());
                return;
            }
            if (mediaContent == null) {
                this.zzbkg.zza((zzacd)null);
                return;
            }
            zzayu.zzea("Use MediaContent provided by UnifiedNativeAd.getMediaContent");
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to call setMediaContent on delegate", remoteException);
            return;
        }
    }
}

